<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Mismo
 */

get_header();
?>
<div class="all-content-wrapper mt-clearfix">
	<div id="primary" class="content-area">
		<main id="main" class="site-main">

			<section class="error-404 not-found">
				<header class="page-header">
					<div class="error-image">
						<i class="fa fa-exclamation-triangle"></i>
						<?php esc_html_e( '404', 'mismo' ); ?>
						<span><?php esc_html_e( 'Error', 'mismo' ); ?></span>
					</div>
					<h1 class="page-title"><?php esc_html_e( 'Sorry!! We couldn&rsquo;t find the page you were looking for.', 'mismo' ); ?></h1>
				</header><!-- .page-header -->

				<div class="page-content">
					<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'mismo' ); ?></p>
					<?php get_search_form(); ?>
				</div><!-- .page-content -->
			</section><!-- .error-404 -->

			<?php 
				$mismo_pnf_latest_posts = get_theme_mod( 'mismo_enable_pnf_latest_posts', true );
				if ( true ===  $mismo_pnf_latest_posts ) {
			?>
					<div class="page-extra-content mismo-404-latest-posts-wrapper">
						<?php
							$mismo_pnf_args = array(
								'post_type' => 'post',
								'posts_per_page' => 5,
								'ignore_sticky_posts' => 1,
							);
							$mismo_pnf_query = new WP_Query( $mismo_pnf_args );
							if ( $mismo_pnf_query->have_posts() ) {
								$mismo_404_latest_title = get_theme_mod( 'mismo_pnf_latest_title', __( 'You May Find Here' ,'mismo' ) );
								echo '<div class="custom-title"><h2 class="section-title widget-title mismo-related-post-title">'. esc_html( $mismo_404_latest_title ) .'</h2></div><!-- .custom-title -->';
								echo '<div class="mismo-pnf-latest-posts-wrapper mismo-related-posts-wrapper mismo-you-may-like-wrapper">';
								while ( $mismo_pnf_query->have_posts() ) {
									$mismo_pnf_query->the_post();

									/*
									* Include the Post-Type-specific template for the content.
									* If you want to override this in a child theme, then include a file
									* called content-___.php (where ___ is the Post Type name) and that will be used instead.
									*/
									get_template_part( 'template-parts/related-posts/content', 'related' );
									
								}
								echo '</div><!-- .mismo-pnf-latest-posts-wrapper -->';
							}
							wp_reset_postdata();
						?>
					</div><!-- .page-extra-content -->
			<?php 
				} 
			?>

		</main><!-- #main -->
	</div><!-- #primary -->

</div><!-- .all-content-wrapper -->
<?php
get_footer();