jQuery(document).ready(function($){
    "use strict";
    
    /**
     * Widgets Active Callback Scripts
     */

    function field_relation_action( relation_field, relation, relations_key ){
        var relation_field_value = relation_field.val();
        for(var relation_key in relation){
            if(relations_key == "empty" || relations_key == "exist"){
                relation_field_value = relations_key;
            }else if(relations_key == "values"){
                if(relation_key != relation_field_value){
                    continue;
                }
            }
            var relation_details = relation[relation_key];
            for(var action_key in relation_details){
                var action_details = relation_details[action_key];
                var action_detail_class = action_details.join(", .");
                var action_class = '.'+action_detail_class;
                switch(action_key){
                    case 'show_fields':
                        relation_field.closest('.widget-content').find(action_class).removeClass('mt-hidden-field');
                        relation_field.closest('.panel-dialog').find(action_class).removeClass('mt-hidden-field');
                        break;
                    case 'hide_fields':
                        relation_field.closest('.widget-content').find(action_class).addClass('mt-hidden-field');
                        relation_field.closest('.panel-dialog').find(action_class).addClass('mt-hidden-field');
                        break;
                    default:
                        console.warn('Action ' + relation_key + ' case is not defined');
                    break;
                }
            }
        }
    }

    function field_relation( relation_field, relation_field_value, relations ){
        if(!relations){
            return;
        }
        for(var relations_key in relations){
            var relation = relations[relations_key];
            if(!relation){
                continue;
            }
            switch(relations_key){
                case 'exist':
                    if( relation_field_value ){
                        field_relation_action(relation_field, {'exist':relation}, relations_key);
                    }
                    break;
                case 'empty':
                    if( !relation_field_value ){
                        field_relation_action(relation_field, {'empty':relation}, relations_key);
                    }
                    break;
                case 'values':
                    if( relation ){
                        field_relation_action(relation_field, relation, relations_key);
                    }
                    break;
                default: 
                    console.warn('Relation key ' + relations_key + 'is not found.');
                    break;
            }
        }
    }

    function widgetUpdate( widget ) {
        $('.mismo_widget_field_relation').each(function(){
            var relation_field = $(this);
            var relation_relation_field_value = relation_field.val();
            var relations = relation_field.data('relations');
            if( !relation_relation_field_value && !relations ) {
                return;
            }
            field_relation( relation_field, relation_relation_field_value, relations );

        });
    }

    $('.mismo_widget_field_relation').each(function(){
        var relation_field = $(this);
        var relation_relation_field_value = relation_field.val();
        var relations = relation_field.data('relations');
        
        if( !relation_relation_field_value && !relations ) {
        return;
        }
        field_relation( relation_field, relation_relation_field_value, relations );

    });

    $('body').on( 'change', '.mismo_widget_field_relation', function() {
        var relation_field = $(this);
        var relation_relation_field_value = relation_field.val();
        var relations = relation_field.data('relations');
        if( !relation_relation_field_value && !relations ) {
        return;
        }
        field_relation( relation_field, relation_relation_field_value, relations );
    });

    $('.mismo_widget_field_relation').trigger('change');

    $( document ).on( 'widget-added widget-updated', function( e, widget ) {
        widgetUpdate( widget );
    });

    // Make required widget fields siteorigin Compatible.
    $( document.body ).on( 'panelsopen', function(e) {
        var target = $( e.target );

        // Check that this is for our widget class
        if( target.has( '.mt-widget-field-wrapper' ) ) {
            $('.mismo_widget_field_relation').each(function(){
                var relation_field = $(this);
                var relation_relation_field_value = relation_field.val();
                var relations = relation_field.data('relations');
                if( !relation_relation_field_value && !relations ) {
                    return;
                }
                field_relation( relation_field, relation_relation_field_value, relations );
            });
        }
    });

    /**
     * Image selector in widget
     *
     */
    $('body').on('click','.selector-labels label', function(){
        var $this = $(this);
        var value = $this.attr('data-val');
        $this.siblings().removeClass('selector-selected');
        $this.addClass('selector-selected');
        $this.closest('.selector-labels').next('input').val(value).trigger('change');
    });

    /**
     * Radio Image control in metabox
     */
    $( '.mt-meta-options-wrap .buttonset' ).buttonset();
});