jQuery(document).ready(function($){
    "use-strict";
    
    var rtl_class = $("body").hasClass("rtl");

    /**
     * Mismo Preloader
     */
    if($('#preloader-background').length > 0) {
        setTimeout(function(){$('#preloader-background').hide();}, 600);
    }

    /**
     * Settings about WOW animation
     */
    var wowOption = mismoObject.wow_effect;
    if( wowOption === 'on' ) {
        new WOW().init();
    }

    $( '.header-sticky-sidebar .sticky-sidebar-toogle').click(function(event) {
        $('.header-sticky-sidebar-content').toggleClass('show');
        $(this).toggleClass('sidebar-open');
    });

    $( '.header-sticky-sidebar .header-sticky-sidebar-close' ).click(function(){
        $('.header-sticky-sidebar-content').removeClass('show');
        $('.sticky-sidebar-toogle').toggleClass('sidebar-open');
    });
    
    $('.header-sticky-sidebar-content').click(function(event) { 
        if ( $(event.target).parents().hasClass('show') ){
            $( '.header-sticky-sidebar-content' ).addClass('show');
        }else{
            $( '.header-sticky-sidebar-content' ).removeClass('show');
        }
    });
    
    /**
     * Settings about sticky header
     */
    var stickyOption = mismoObject.header_sticky;
    if( stickyOption === 'on' ) {
        var windowWidth = $( window ).width();
        if( windowWidth < 500 ) {
            var wpAdminBar = 0;
        } else {
            var wpAdminBar = $('#wpadminbar');
        }
        if ( wpAdminBar.length ) {
          $("#m-main-header").sticky({topSpacing:wpAdminBar.height()});
        } else {
          $("#m-main-header").sticky({topSpacing:0});
        }
    }

    /**
     * Sticky sidebar
     */
    var sidebarSticky = mismoObject.sidebar_sticky;
    if( sidebarSticky === 'on' ) {
        $('#primary, #secondary').theiaStickySidebar({
            additionalMarginTop: 40
        });
    }

    /**
     * Top Highlight Post slide handle
     */
    $('.highlight-post-wrap').marquee({
        delayBeforeStart:2000,
        duration : 50000,
        pauseOnHover : true,
        startVisible: true,
        duplicated: true,
    });

    /**
     * Header search icon scripts
     */
    $( '#m-search-wrapper .search-form-open' ).click(function(){
        $(this).next().toggleClass( 'search-form-show' ).toggleClass( 'search-form-hidden' );
        $('.main-navigation' ).toggleClass( 'search-form-show' );
    });
    $( '#m-search-wrapper .search-close' ).click(function(){
        $('.m-search-form' ).removeClass( 'search-form-show' );
        $('.main-navigation' ).removeClass( 'search-form-show' );
    });

    /*
     * Slider for header banner section
     *
     */
    $(".m-banner-slider").lightSlider({
        item: 1,
        auto: false,
        loop: true,
        pager: true,
        controls: true,
        slideMargin: 0,
        rtl: rtl_class,
        nextHtml: '<i class="fa fa-angle-right"></i>',
        prevHtml: '<i class="fa fa-angle-left"></i>',
        onSliderLoad: function() {
            $(".m-banner-slider").removeClass('cS-hidden');

            var container = ".m-banner-slider";
            var fullwidthHeight = '650';
            $(container).closest('.banner-section-wrapper.full-banner--width').find("article").css('height',fullwidthHeight);

            var imageHeight = $(container).closest('.banner-section-wrapper').height();
            $(container).css('height',imageHeight);
            $(container).closest('.banner-section-wrapper.default-banner--width').find(".banner-slider-wrap article").css('height',imageHeight);

            $(container).css('height',imageHeight);
            $(container).closest('.banner-section-wrapper.right-full-banner--width').find(".banner-slider-wrap article").css('height',imageHeight);

            $(container).css('height',imageHeight);
            $(container).closest('.banner-section-wrapper.left-full-banner--width').find(".banner-slider-wrap article").css('height',imageHeight);
        },
    });

    /*
     * Slider for grid carousel widget
     *
     */
    $('.m-carousel-grid-posts-wrapper').each(function() {
        var Id = $(this).parents('.widget').attr('id');
        $('#' + Id + " .m-carousel-grid-posts-content").each(function() {
            var sID = $(this).attr( 'id' );
            var NewId = $('#' + Id + ' #' + sID ).lightSlider({
                loop: true,
                pager: false,
                controls: false,
                auto: false,
                rtl: rtl_class,
                mode: 'slide',
                item: 4,
                onSliderLoad: function() {
                    $('#' + Id + ' #' + sID).removeClass('cS-hidden');
                }, 
                responsive: [{
                        breakpoint: 840,
                        settings: {
                            item: 2,
                            slideMove: 1,
                            slideMargin: 6,
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            item: 1,
                            slideMove: 1,
                        }
                    }
                ]
            });

            $('#' + Id + ' .lSPrev').click(function() {
                NewId.goToPrevSlide();
            });

            $('#' + Id + ' .lSNext').click(function(){
                NewId.goToNextSlide();
            });
        });
    });

    /**
     * Gallery Post format slider
     */
    $('.format-gallery .gallery-slider').lightSlider({
        item: 1,
        loop: true,
        controls: true,
        pager: false,
        nextHtml: '<i class="fa fa-angle-right"></i>',
        prevHtml: '<i class="fa fa-angle-left"></i>',
    });

    /**
     * Default carousel widget
     */
    $(".m-carousel-grid-posts-wrapper").tabs();
    $("#m-tabbed-widget").tabs();

    /**
     * Scroll To Top
     */
    $(window).scroll(function() {
        if ($(this).scrollTop() > 1000) {
            $('#m-scrollup').fadeIn('slow');
        } else {
            $('#m-scrollup').fadeOut('slow');
        }
    });
    $('#m-scrollup').click(function() {
        $("html, body").animate({
            scrollTop: 0
        }, 600);
        return false;
    });
    /** 
     * menu toggle 
     */

    $('#site-navigation .menu-toggle').click(function(){
        $('#site-navigation #primary-menu').slideToggle('slow');
    });

    /**
     * responsive sub menu toggle
     */
        $('<a class="sub-toggle" href="javascript:void(0);"><i class="fa fa-angle-right"></i></a>').insertAfter('#site-navigation .menu-item-has-children>a, #site-navigation .page_item_has_children>a');

        $('#site-navigation .sub-toggle').click(function() {
            $(this).parent('.menu-item-has-children').children('ul.sub-menu').first().slideToggle('1000');
            jQuery(this).parent('.page_item_has_children').children('ul.children').first().slideToggle('1000');
            $(this).children('.fa-angle-right').first().toggleClass('fa-angle-down');
        });
});