<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Mismo
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
	if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
		/*
	 	 * hook - body_open_hook
	 	 */
	    do_action( 'body_open_hook' );
	}
	/**
	 * mismo_before_page - hook
	 * 
	 * @hooked -mismo_preloader -5
	 * 
	 */
	do_action( 'mismo_before_page' );
?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'mismo' ); ?></a>

<?php
	/**
	 * hook - mismo_header_open
	 * 
	 * @hooked - mismo_site_header_tag_open - 10
	 */
	do_action( 'mismo_header_open' );
	
	/**
	 * hook - mismo_top_header
	 * 
	 * @hooked - mismo_site_top_header_start - 10
	 * @hooked - mismo_top_header_site_branding - 20
	 * @hooked - mismo_site_top_header_highlight_post - 30
	 * @hooked - mismo_site_top_header_end - 100
	 */
	do_action( 'mismo_top_header' );

	/**
	 * hook - mismo_header
	 * 
	 * @hooked - mismo_site_header_start - 10
	 * @hooked - mismo_header_navigation_menu - 20
	 * @hooked - mismo_header_search_icon - 40
	 * @hooked - mismo_site_header_end - 100
	 */
	do_action( 'mismo_header' );

	$mismo_trending_tags_sec_option = get_theme_mod( 'mismo_trending_tags_sec_option', true );
	/**
	 * hook - header_trending_tags_sec
	 * 
	 * @hooked - mismo_trending_tags_sec_start - 10
	 * @hooked - mismo_site_header_site_detail - 20
	 * @hooked - mismo_site_header_date - 30
	 * @hooked - mismo_trending_tags_sec_end - 100
	 */
	if ( is_front_page() && true == $mismo_trending_tags_sec_option ) {
		do_action( 'header_trending_tags_sec' );
	}

	/**
	 * Sidebar content for header advertisements banner.
	 * 
	 */
	if ( is_active_sidebar( 'header-ads-area' ) && is_front_page() ) {
		echo '<div id="sidebar-header-ads-area">';
		echo '<div class="mt-container">';
			dynamic_sidebar( 'header-ads-area' );
		echo '</div> <!-- mt-container -->';
		echo '</div><!-- #sidebar-header-ads-area -->';				
	}

	/**
	 * hook - mismo_header_close
	 * 
	 * @hooked - mismo_site_header_tag_close - 10
	 */
	do_action( 'mismo_header_close' );

	/**
	 * hook - mismo_innerpages_header_image
	 * 
	 * @hooked - mismo_innerpages_header_image_sec - 10
	 * @hooked - mismo_breadcumb_trail_sec - 20
	 * 
	 */
	if ( !is_front_page() ) {
		do_action( 'mismo_innerpages_header_image' );
	}
?>

	<div id="content" class="site-content">
		<div class="mt-container">