<?php
/**
 * Handles all the hooks of theme footer section
 * 
 * @package Mismo
 * @since 1.0.0 
 */

add_action( 'mismo_footer_open', 'mismo_site_footer_tag_open', 10 );
if ( ! function_exists( 'mismo_site_footer_tag_open' ) ) :

    /**
     * Function footer tag open
     */
    function mismo_site_footer_tag_open() {
        echo '<footer id="colophon" class="site-footer">';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'mismo_footer_close', 'mismo_site_footer_tag_close', 10 );
if ( ! function_exists( 'mismo_site_footer_tag_close' ) ) :

    /**
     * Function footer tag close
     */
    function mismo_site_footer_tag_close() {
        echo '</footer><!-- #colophon -->';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'mismo_footer_widget_area', 'mismo_footer_widget_section', 20 );
if ( ! function_exists( 'mismo_footer_widget_section' ) ) :

    /**
     * Footer widget section
     *
     * @since 1.0.0
     */
	function mismo_footer_widget_section() {
		get_sidebar( 'footer' );
	}

endif;

/*-----------------------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'mismo_bottom_footer_widget_area', 'mismo_bottom_footer_widget_section', 20 );
if ( ! function_exists( 'mismo_bottom_footer_widget_section' ) ) :

    /**
     * Bottom Footer widget section
     *
     * @since 1.0.0
     */
	function mismo_bottom_footer_widget_section() {
		get_sidebar( 'bottom-footer' );
	}

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_bottom_footer_start' ) ) :

    /**
     * Function bottom footer start
     */
    function mismo_bottom_footer_start() {
        echo '<div id="m-bottom-footer">';
        echo '<div class="mt-container">';
    }

endif;

if ( ! function_exists( 'mismo_bottom_footer_site_info' ) ) :

    /**
     * Function bottom footer site info
     */
    function mismo_bottom_footer_site_info() { ?>
        <div class="site-info">
            <?php
                $mismo_bottom_section_copyright_txt = get_theme_mod( 'mismo_bottom_section_copyright_txt', __( 'Copyright', 'mismo' ) );
                echo wp_kses_post( $mismo_bottom_section_copyright_txt );
            ?>
            <span class="sep"> | </span>
            <?php
                /* translators: 1: Theme name, 2: Theme author. */
                $theme_author_url = 'https://mysterythemes.com/';
                printf( esc_html__( 'Theme: %1$s by %2$s.', 'mismo' ), 'Mismo', '<a href="'.esc_url( $theme_author_url ).'" rel="designer" target="_blank">Mystery Themes</a>' );
            ?>
        </div><!-- .site-info -->
<?php        
    }

endif;

if ( ! function_exists( 'mismo_bottom_footer_end' ) ) :

    /**
     * Function bottom footer end
     */
    function mismo_bottom_footer_end() {
        echo '</div><!-- mt-container -->';
        echo '</div><!-- #m-bottom-footer -->';
    }

endif;

add_action( 'mismo_bottom_footer', 'mismo_bottom_footer_start', 10 );
add_action( 'mismo_bottom_footer', 'mismo_bottom_footer_site_info', 20 );
add_action( 'mismo_bottom_footer', 'mismo_bottom_footer_end', 50 );

/*-------------------------------------------------- Scroll To Top section ---------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_scrol_to_top' ) ) :

    /**
     * Function for scroll to top  element at footer.
     */
    function mismo_scrol_to_top() {
        $mismo_scroll_to_top_option = get_theme_mod( 'mismo_scroll_to_top_option', true );
        if ( true != $mismo_scroll_to_top_option ) {
            return;
        }
        echo '<div id="m-scrollup" class="animated arrow-hide"><i class="fa fa-arrow-up"></i></div>';
    }

endif;

add_action( 'mismo_footer_close', 'mismo_scrol_to_top', 50 );