<?php
/**
 * Handles all the hooks of theme header section
 * 
 * @package Mismo
 * @since 1.0.0 
 */

add_action( 'mismo_header_open', 'mismo_site_header_tag_open', 10 );
if ( ! function_exists( 'mismo_site_header_tag_open' ) ) :

    /**
     * Function header tag open
     */
    function mismo_site_header_tag_open() {
        echo '<header id="masthead" class="site-header">';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'mismo_header_close', 'mismo_site_header_tag_close', 10 );
if ( ! function_exists( 'mismo_site_header_tag_close' ) ) :

    /**
     * Function header tag close
     */
    function mismo_site_header_tag_close() {
        echo '</header><!-- #masthead -->';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
                                                            /* Top Header Section */
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/

if ( ! function_exists( 'mismo_site_top_header_start' ) ) :

    /**
     * Function top header start
     */
    function mismo_site_top_header_start() {
        $mismo_highlight_post_option = get_theme_mod( 'mismo_highlight_post_option', true ); ?>
        <div id="m-top-header" <?php if ( $mismo_highlight_post_option == false ) { echo 'class="no-highlight-post"'; } ?>>
        <div class="mt-container">
        <div class="top-header-wrap mt-clearfix">
<?php
    }

endif;
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_top_header_site_branding' ) ) :

    /**
     * Function header top site branding
     */
    function mismo_top_header_site_branding() {
?>
        <div class="sticky-sidebar-logo-wrap">
            <div class="site-branding">
                <?php
                the_custom_logo();
                if ( is_front_page() && is_home() ) :
                    ?>
                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                    <?php
                else :
                    ?>
                    <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                    <?php
                endif;
                $mismo_description = get_bloginfo( 'description', 'display' );
                if ( $mismo_description || is_customize_preview() ) :
                    ?>
                    <p class="site-description"><?php echo esc_html( $mismo_description ); /* WPCS: xss ok. */ ?></p>
                <?php endif; 
                ?>
            </div><!-- .site-branding -->
            <?php mismo_top_header_sticky_sidebar(); ?>
        </div><!-- .sticky-sidebar-logo-wrap -->
<?php
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_top_header_highlight_post' ) ) :

    /**
     * Function top header highlight post
     */
    function mismo_site_top_header_highlight_post() {
        $hp_query = new WP_Query( array( 'post_type' => 'post', 'posts_per_page' => 5 ) );
        $mismo_highlight_post_option = get_theme_mod( 'mismo_highlight_post_option', true );
        if ( true != $mismo_highlight_post_option || !( $hp_query -> have_posts() ) ) {
            return;
        }
        $mismo_highlight_post_title = get_theme_mod( 'mismo_highlight_post_title', __( 'Just Posted', 'mismo' ) ); ?>
        <div class="top-header-highlight-post <?php if ( empty( $mismo_highlight_post_title ) ) { echo 'no-title'; } ?>">
            <?php 
            if ( ! empty( $mismo_highlight_post_title ) ) {
                echo '<div class="highlight-post-main-title">'.esc_html( $mismo_highlight_post_title ).'</div>';
            }

                echo '<div class="highlight-post-wrap">';
                    while ( $hp_query -> have_posts() ) : $hp_query -> the_post();
                        echo '<div class="highlight-post-thumb-wrap">';
                            the_post_thumbnail( 'thumbnail' );
            ?>
                            <div class="highlight-post-title-wrap">
                                <div class="highlight-post-title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </div>
                                <div class="entry-meta">
                                    <?php mismo_post_time(); ?>
                                </div><!-- .entry-meta -->
                            </div><!-- highlight-post-title-wrap -->
            <?php
                        echo '</div><!-- .highlight-post-thumb-wrap -->';
                    endwhile; 
                echo '</div><!-- .highlight-post-wrap -->';
            ?>
        </div><!-- .top-header-highlight-post -->
<?php
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_top_header_end' ) ) :

    /**
     * Function top header end
     */
    function mismo_site_top_header_end() {
        echo '</div><!-- .top-header-wrap -->';
        echo '</div><!-- .mt-container -->';
        echo '</div><!-- #m-top-header -->';
    }

endif;
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'mismo_top_header', 'mismo_site_top_header_start', 10 );
add_action( 'mismo_top_header', 'mismo_top_header_site_branding', 20 );
add_action( 'mismo_top_header', 'mismo_site_top_header_highlight_post', 30 );
add_action( 'mismo_top_header', 'mismo_site_top_header_end', 100 );

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
                                                                /* Header Section */
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_header_start' ) ) :

    /**
     * Function header start
     */
    function mismo_site_header_start() {
        echo '<div id="m-main-header">';
        echo '<div class="mt-container">';
        echo '<div class="nav-search-wrapper mt-clearfix">';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_header_navigation_menu' ) ) :

    /**
     * Function header navigation menu
     */
    function mismo_header_navigation_menu() { ?>
        <nav id="site-navigation" class="main-navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><a href="javascript:void(0)"><i class="fa fa-navicon"></i></a></button>
			<?php
                wp_nav_menu( array(
                    'theme_location' => 'menu-1',
                    'menu_id'        => 'primary-menu'
                ) );
			?>
		</nav><!-- #site-navigation -->
<?php
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_header_search_icon' ) ) :

    /**
     * Function header search icon.
     */
    function mismo_header_search_icon() {

        $mismo_follow_icons_option = get_theme_mod( 'mismo_follow_icons_option', false );
        $mismo_search_icon_option = get_theme_mod( 'mismo_search_icon_option', false );
        if ( true != $mismo_follow_icons_option && true != $mismo_search_icon_option ) {
            return;
        }

        echo '<div class="icon-search-wrapper">';
            if ( true == $mismo_follow_icons_option ) {
                mismo_social_icons();
            }
            if ( true == $mismo_search_icon_option ) {
    ?>
                <div id="m-search-wrapper">
                    <div class="search-form-open"><i class="fa fa-search" aria-hidden="true"></i></div>
                    <div class="m-search-form search-form-hidden">
                        <div class="search-form-open"><i class="fa fa-search" aria-hidden="true"></i></div>
                        <?php echo get_search_form(); ?>
                        <div class="search-close"><i class="fa fa-times" aria-hidden="true"></i></div>
                    </div>
                </div><!-- #m-search-wrapper -->
    <?php
            }
        echo '</div><!-- .icon-search-wrapper -->';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_header_end' ) ) :

    /**
     * Function header end
     */
    function mismo_site_header_end() {
        echo '</div><!-- .nav-search-wrapper -->';
        echo '</div><!-- .mt-container -->';
        echo '</div><!-- #m-main-header -->';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'mismo_header', 'mismo_site_header_start', 10 );
add_action( 'mismo_header', 'mismo_header_navigation_menu', 20 );
add_action( 'mismo_header', 'mismo_header_search_icon', 40 );
add_action( 'mismo_header', 'mismo_site_header_end', 100 );


/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
                                                    /* Trending Tags Section */ 
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/

if ( ! function_exists( 'mismo_trending_tags_sec_start' ) ) :

    /**
     * Function trending tag section start
     */
    function mismo_trending_tags_sec_start() {
        echo '<div id="trending-tags-section">';
        echo '<div class="mt-container">';
        echo '<div class="tag-detail-wrapper mt-clearfix">';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_trending_tags_items' ) ) :

    /**
     * function to display the trending tags items  
     *
     */
    function mismo_trending_tags_items() {
		$mismo_enable_trending_tags_items = get_theme_mod( 'mismo_enable_trending_tags_items', false );
		if ( false === $mismo_enable_trending_tags_items ) {
			return;
		}

		$mismo_enable_trending_tags_items_before_icon = get_theme_mod( 'mismo_enable_trending_tags_items_before_icon', true );
		if ( $mismo_enable_trending_tags_items_before_icon == true ) {
			$before_icon = 'tag-before-icon';
		} else {
			$before_icon = '';
		}
		$trending_tags_item_label = get_theme_mod( 'mismo_enable_trending_tags_items_label', __( 'Trending Now', 'mismo' ) );
?>
        <div class="trending-wrapper <?php echo esc_attr( $before_icon ); ?>">
            <?php 
                if ( ! empty( $trending_tags_item_label ) ) {
                    echo '<span class="wrap-label">'.esc_html( $trending_tags_item_label ).'</span>';
                }
            ?>
            <div class="tags-wrapper">
				<?php
					$mismo_enable_trending_tags_items_orderby = get_theme_mod( 'mismo_enable_trending_tags_items_orderby', '' );
					$mismo_trending_tags_items_count = get_theme_mod( 'mismo_trending_tags_items_count', '5' );
					$get_tags_lists = get_tags( array(
                        'orderby'=> esc_attr( $mismo_enable_trending_tags_items_orderby ),
                        'number' => absint( $mismo_trending_tags_items_count ),	
                    ));
					if ( ! empty( $get_tags_lists ) ) {
						echo '<span class="head-tags-links">';
						foreach( $get_tags_lists as $tag ) {
							echo '<a href="'. esc_url( get_tag_link( $tag->term_id ) ).'" rel="tag">'. esc_html( $tag->name ) .'</a>';
						}
						echo '</span>';
					}
                ?>
            </div><!-- .tags-wrapper -->
        </div><!-- .trending-wrapper -->
<?php
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_header_site_detail_date_wrap_start' ) ) :

    /**
     * Function top header site detail date wrap start 
     */
    function mismo_site_header_site_detail_date_wrap_start() {
        echo '<div class="site-detail-date-wrap">';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_header_site_detail' ) ) :

    /**
     * Function top header site detail
     */
    function mismo_site_header_site_detail() {
        $mismo_header_address_text = get_theme_mod( 'mismo_header_address_text', __( 'Street-1, NY', 'mismo' ) );
        $mismo_header_email_text = get_theme_mod( 'mismo_header_email_text', __( 'mismo@example.com', 'mismo' ) );
        $mismo_header_contact_number = get_theme_mod( 'mismo_header_contact_number', __( '+999-123456789', 'mismo' ) );
        if ( empty( $mismo_header_address_text ) && empty( $mismo_header_email_text ) && empty( $mismo_header_contact_number ) ) {
            return;
        }

        
        echo '<div class="site-detail-wrap">';
            if ( ! empty( $mismo_header_address_text ) ) {
                echo '<div class="top-header-address-text site-detail">'. esc_html( $mismo_header_address_text ) .'</div><!-- .top-header-address-text -->';
            }

            if ( ! empty( $mismo_header_email_text ) ) {
                echo '<div class="top-header-email-text site-detail">'. esc_html( $mismo_header_email_text ) .'</div><!-- .top-header-email-text -->';
            }

            if ( ! empty( $mismo_header_contact_number ) ) {
                echo '<div class="top-header-contact-number site-detail">'. esc_html( $mismo_header_contact_number ) .'</div><!-- .top-header-contact-number -->';
            }

        echo '</div><!-- .site-detail-wrap -->';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_header_date' ) ) :

    /**
     * Function header date
     */
    function mismo_site_header_date() {
        $mismo_header_date_option = get_theme_mod( 'mismo_header_date_option', '1' );
        if ( true != $mismo_header_date_option ) {
            return;
        }
        echo '<div class="date-element site-detail">'. esc_html( date_i18n( get_option( 'date_format' ) ) ) .'</div>';
    }
    
endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_site_header_site_detail_date_wrap_end' ) ) :

    /**
     * Function top header site detail date wrap end 
     */
    function mismo_site_header_site_detail_date_wrap_end() {
        echo '</div> <!-- .site-detail-date-wrap -->';
    }

endif;

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/

if ( ! function_exists( 'mismo_trending_tags_sec_end' ) ) :

    /**
     * Function trending tag section end
     */
    function mismo_trending_tags_sec_end() {
                echo '</div><!-- .tag-detail-wrapper -->';
            echo '</div><!-- .mt-container -->';
        echo '</div><!-- #trending-tags-section -->';
    }

endif;
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'header_trending_tags_sec', 'mismo_trending_tags_sec_start', 10 );
add_action( 'header_trending_tags_sec', 'mismo_trending_tags_items', 20 );
add_action( 'header_trending_tags_sec', 'mismo_site_header_site_detail_date_wrap_start', 30 );
add_action( 'header_trending_tags_sec', 'mismo_site_header_site_detail', 40 );
add_action( 'header_trending_tags_sec', 'mismo_site_header_date', 50 );
add_action( 'header_trending_tags_sec', 'mismo_site_header_site_detail_date_wrap_end', 60 );
add_action( 'header_trending_tags_sec', 'mismo_trending_tags_sec_end', 100 );
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------------------------------------------------------------------------------*/
                                                // Inner Pages Breadcrumbs function //
/*------------------------------------------------------------------------------------------------------------------------------------------------------*/

if ( ! function_exists( 'mismo_breadcumb_trail_sec' ) ) :

    /**
     * Function for breadcrumb trail.
     */
    function mismo_breadcumb_trail_sec() {
        $mismo_breadcumb_option = get_theme_mod( 'mismo_breadcumb_option', true );
        if ( true != $mismo_breadcumb_option ) {
            return;
        }
?>
        <nav id="breadcrumb" class="m-breadcrumb">
            <?php
            breadcrumb_trail( array(
                'container'   => 'div',
                'before'      => '<div class="mt-container">',
                'after'       => '</div>',
                'show_browse' => false,
            ) );
            ?>
        </nav>
<?php
    }

endif;

add_action( 'mismo_innerpages_header_image', 'mismo_breadcumb_trail_sec', 10 );