<?php
/**
 * Define path for required files for Custom Control
 * 
 * @package Mismo
*/

if ( ! function_exists( 'mismo_register_custom_classes' ) ) :
    
    /**
     * Register Custom Controls
     * 
     * @since 1.0.0
    */
    function mismo_register_custom_classes( $wp_customize ) {
        
        // Load our custom control.
        require_once get_template_directory() . '/inc/customizer/custom-classes/toggle/class-toggle-control.php';
        require_once get_template_directory() . '/inc/customizer/custom-classes/repeater/class-repeater-control.php';
        require_once get_template_directory() . '/inc/customizer/custom-classes/radio-image/class-radio-image-control.php';


        // Register the control type.
        $wp_customize->register_control_type( 'Mismo_Control_Toggle' );
        $wp_customize->register_control_type( 'Mismo_Control_Radio_Image' );
    }

endif;

add_action( 'customize_register', 'mismo_register_custom_classes' );