<?php
/**
 * Mismo Theme Customizer
 *
 * @package Mismo
 */

// Load upsell section
require_once get_template_directory() . '/inc/customizer/custom-classes/theme-upsell/m-theme-upsell-section.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function mismo_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	$wp_customize->remove_section( 'header_image' );
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'mismo_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'mismo_customize_partial_blogdescription',
		) );
	}

	$wp_customize->register_section_type( 'Mismo_Customize_Section_Upsell' );

    /**
     * Register theme upsell sections.
     *
     * @since 1.0.2
     */
    $wp_customize->add_section( new Mismo_Customize_Section_Upsell(
        $wp_customize,
            'mismo_theme_upsell',
            array(
                'title'    	=> esc_html__( 'Mismo Pro', 'mismo' ),
                'pro_text' 	=> esc_html__( 'Buy Now', 'mismo' ),
                'pro_url'  	=> 'https://mysterythemes.com/wp-themes/mismo-pro/',
                'priority' 	=> 1,
            )
        )
    );

}
add_action( 'customize_register', 'mismo_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function mismo_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function mismo_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function mismo_customize_preview_js() {
	wp_enqueue_script( 'mismo-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'mismo_customize_preview_js' );

/**
 * Binds JS handlers to make Theme Customizer Controls.
 */
function mismo_customize_controls_scripts() {
	global $mismo_theme_version;

	wp_enqueue_style( 'font-awesome-customizer-style', get_template_directory_uri().'/assets/library/font-awesome/css/font-awesome.min.css', array(), '4.7.0' );

	wp_enqueue_style( 'mismo-theme-upsell-style', get_template_directory_uri() . '/inc/customizer/custom-classes/theme-upsell/theme-upsell.css', array(), esc_attr( $mismo_theme_version ) );

	wp_enqueue_script( 'mismo-theme-upsell-script', get_template_directory_uri() . '/inc/customizer/custom-classes/theme-upsell/theme-upsell.js', array( 'jquery' ), esc_attr( $mismo_theme_version ), true );
}
add_action( 'customize_controls_enqueue_scripts', 'mismo_customize_controls_scripts' );

/**
 * Load custom customizer settings files 
 * 
 */
require get_template_directory() . '/inc/customizer/custom-classes/custom-classes.php';
require get_template_directory() . '/inc/customizer/m-customizer-panels.php';
require get_template_directory() . '/inc/customizer/m-panels-settings/m-general-panel-settings.php';
require get_template_directory() . '/inc/customizer/m-panels-settings/m-color-panel-settings.php';
require get_template_directory() . '/inc/customizer/m-panels-settings/m-header-panel-settings.php';
require get_template_directory() . '/inc/customizer/m-panels-settings/m-design-panel-settings.php';
require get_template_directory() . '/inc/customizer/m-panels-settings/m-footer-panel-settings.php';
require get_template_directory() . '/inc/customizer/m-panels-settings/m-additional-panel-settings.php';

require get_template_directory() . '/inc/customizer/m-callback.php';
require get_template_directory() . '/inc/customizer/m-sanitize.php';