<?php
/**
 * Define callback functions for callback functions.
 * 
 * @package Mismo
 */

if ( ! function_exists( 'mismo_highlight_post_option_active_callback' ) ) :

    /**
	 * Check if highlight post option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_highlight_post_option_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_highlight_post_option' )->value() ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;

if ( ! function_exists( 'mismo_trending_tags_sec_option_active_callback' ) ) :

    /**
	 * Check if trending tags section option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_trending_tags_sec_option_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_trending_tags_sec_option' )->value() ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;


if ( ! function_exists( 'mismo_trending_tags_sec_and_tags_items_option_active_callback' ) ) :

    /**
	 * Check if trending tags section and tags items option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_trending_tags_sec_and_tags_items_option_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_trending_tags_sec_option' )->value() && false !== $control->manager->get_setting( 'mismo_enable_trending_tags_items' )->value() ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;

if ( ! function_exists( 'mismo_footer_widget_option_active_callback' ) ) :

    /**
	 * Check if footer widget option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_footer_widget_option_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_footer_widget_option' )->value()  ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;

if ( ! function_exists( 'mismo_bottom_footer_widget_option_active_callback' ) ) :

    /**
	 * Check if bottom footer widget option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_bottom_footer_widget_option_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_bottom_footer_widget_option' )->value()  ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;

if ( ! function_exists( 'mismo_breadcumb_option_active_callback' ) ) :

    /**
	 * Check if breadcumb option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_breadcumb_option_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_breadcumb_option' )->value()  ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;

if ( ! function_exists( 'mismo_enable_related_posts_active_callback' ) ) :

    /**
	 * Check if related posts option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_enable_related_posts_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_enable_related_posts' )->value()  ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;

if ( ! function_exists( 'mismo_enable_pnf_latest_posts_active_callback' ) ) :

    /**
	 * Check if pnf latest posts option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_enable_pnf_latest_posts_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_enable_pnf_latest_posts' )->value() ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;

if ( ! function_exists( 'mismo_enable_you_may_missed_active_callback' ) ) :

    /**
	 * Check if related posts option is enabled.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
    function mismo_enable_you_may_missed_active_callback( $control ) {
        if ( false !== $control->manager->get_setting( 'mismo_enable_you_may_missed' )->value()  ) {
            return true;
        } else {
            return false;
        }
    }
    
endif;