<?php
/**
 * Mismo Theme Customizer to handle all the panels.
 *
 * @package Mismo
 */

add_action( 'customize_register', 'mismo_customize_register_panels' );
/**
 * Register required theme panels.
 * 
 */
function mismo_customize_register_panels( $wp_customize ) {
    /**
     * Add General panel
     */
    $wp_customize->add_panel( 'mismo_general_panel',
		array(
			'priority'          => 5,
			'capability'        => 'edit_theme_options',
			'theme_supports'    => '',
			'title'             => __( 'General Setting', 'mismo' ),
		)
    );
    
    /**
     * Add Color panel
     */
    $wp_customize->add_panel( 'mismo_color_panel',
		array(
			'priority'          => 20,
			'capability'        => 'edit_theme_options',
			'theme_supports'    => '',
			'title'             => __( 'Color Setting', 'mismo' ),
		)
    );
    
    /**
     * Add Theme Image panel
     */
    $wp_customize->add_panel( 'mismo_image_panel',
		array(
			'priority'          => 30,
			'capability'        => 'edit_theme_options',
			'theme_supports'    => '',
			'title'             => __( 'Theme Image Setting', 'mismo' ),
		)
    );
    
    /**
     * Add Theme Header panel
     */
    $wp_customize->add_panel( 'mismo_header_panel',
		array(
			'priority'          => 35,
			'capability'        => 'edit_theme_options',
			'theme_supports'    => '',
			'title'             => __( 'Header Panel', 'mismo' ),
		)
	);

	/**
     * Add Design panel
     */
    $wp_customize->add_panel( 'mismo_design_panel',
		array(
			'priority'          => 50,
			'capability'        => 'edit_theme_options',
			'theme_supports'    => '',
			'title'             => __( 'Design Panel', 'mismo' ),
		)
	);

	/**
     * Add Additional panel
     */
    $wp_customize->add_panel( 'mismo_additional_panel',
		array(
			'priority'          => 50,
			'capability'        => 'edit_theme_options',
			'theme_supports'    => '',
			'title'             => __( 'Additional Panel', 'mismo' ),
		)
	);

	/**
     * Add Footer panel
     */
    $wp_customize->add_panel( 'mismo_footer_panel',
		array(
			'priority'          => 50,
			'capability'        => 'edit_theme_options',
			'theme_supports'    => '',
			'title'             => __( 'Footer Panel', 'mismo' ),
		)
	);
}