<?php
/**
 * Mismo Theme Customizer to handle all the settings of additional panels.
 *
 * @package Mismo
 */

add_action( 'customize_register', 'mismo_customize_register_additional_panel_settings' );

/**
 * Settings for additional panel
 * 
 */
function mismo_customize_register_additional_panel_settings( $wp_customize ) {

    /*--------------------------------------------------------- Social Media Section ---------------------------------------------------------------------*/
    /** 
	 * Social Media Section
	 */
	$wp_customize->add_section( 'mismo_social_media_section',
        array(
            'priority'       => 5,
            'panel'          => 'mismo_additional_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Social Icons Setting', 'mismo' )
        )
    );
    
    /**
     * Repeater field for Follow Us Icons
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting(
        'mismo_social_icons', 
        array(
            'capability'       => 'edit_theme_options',
            'default'          => json_encode(array(
                    array(
                        'mismo_icons_list' => 'fa fa-facebook-f',
                        'mismo_url_field'  => '#',
                    )
                )
            ),
            'sanitize_callback' => 'wp_kses_post'
        )
    );
    $wp_customize->add_control( new Mismo_Control_Repeater(
        $wp_customize, 
            'mismo_social_icons', 
            array(
                'label'           => __( 'Social Media', 'mismo' ),
                'section'         => 'mismo_social_media_section',
                'settings'        => 'mismo_social_icons',
                'priority'        => 15,   
                'mismo_box_label_text'       => __( 'Follow Icons','mismo' ),
                'mismo_box_add_control_text' => __( 'Add Icon','mismo' ),
            ),
            array(
                'mismo_icons_list' => array(
                    'type'        => 'social_icon',
                    'label'       => __( 'Follow us Logo', 'mismo' ),
                    'description' => __( 'Choose follow us icon.', 'mismo' ),
                    'default'     => 'fa fa-facebook-f'
                ),
                'mismo_url_field' => array(
                    'type'        => 'url',
                    'label'       => __( 'Icon Url', 'mismo' ),
                    'description' => __( 'Enter social url.', 'mismo' ),
                    'default'     => '#'  
                )
            )
        ) 
    );

    /*--------------------------------------------------------- Breadcrumbs Settings Section ---------------------------------------------------------------------*/
    /** 
	 * Breadcrumbs Setting Section
	 */
	$wp_customize->add_section( 'mismo_breadcumb_section',
        array(
            'priority'       => 10,
            'panel'          => 'mismo_additional_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Breadcrumbs Setting', 'mismo' )
        )
    );

    /**
     * Mismo Breadcrumb Option
     */
    $wp_customize->add_setting( 'mismo_breadcumb_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_breadcumb_option',
            array(
                'label'         => __( 'Show Breadcumbs', 'mismo' ),
                'section'       => 'mismo_breadcumb_section',
                'settings'      => 'mismo_breadcumb_option',
                'priority'      => 5,
            )
        )
    );

    /**
	 * Text field for breadcrumbs home text
	 */
	$wp_customize->add_setting( 'mismo_bread_home_text',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => esc_html__( 'Home', 'mismo' ),
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control( 'mismo_bread_home_text', array(
        'type'			=> 'text',
        'label'    => esc_html__( 'Home Text', 'mismo' ),
        'section'       => 'mismo_breadcumb_section',
        'priority'      => 15,
        'active_callback' => 'mismo_breadcumb_option_active_callback',
    ) );

    /*--------------------------------------------------------- Site Extra Section ---------------------------------------------------------------------*/
    /** 
	 * Site Extra Setting Section
	 */
	$wp_customize->add_section( 'mismo_extra_section',
        array(
            'priority'       => 15,
            'panel'          => 'mismo_additional_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Extra Options', 'mismo' )
        )
    );

    /**
     * Mismo Sticky Menu Option
     */
    $wp_customize->add_setting( 'mismo_sticky_header_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_sticky_header_option',
            array(
                'label'         => __( 'Enable Sticky Header', 'mismo' ),
                'section'       => 'mismo_extra_section',
                'settings'      => 'mismo_sticky_header_option',
                'priority'      => 5,
            )
        )
    );

    /**
     * Mismo Sticky sidebar Option
     */
    $wp_customize->add_setting( 'mismo_sticky_sidebar_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_sticky_sidebar_option',
            array(
                'label'         => __( 'Enable Sticky Sidebar', 'mismo' ),
                'section'       => 'mismo_extra_section',
                'settings'      => 'mismo_sticky_sidebar_option',
                'priority'      => 20,
            )
        )
    );

    /**
     * Mismo Scroll To Top Option
     */
    $wp_customize->add_setting( 'mismo_scroll_to_top_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_scroll_to_top_option',
            array(
                'label'         => __( 'Show Scroll To Top', 'mismo' ),
                'section'       => 'mismo_extra_section',
                'settings'      => 'mismo_scroll_to_top_option',
                'priority'      => 50,
            )
        )
    );

    /*--------------------------------------------------------- You May Missed Section ---------------------------------------------------------------------*/
    /** 
     * You May Missed Section
     */
    $wp_customize->add_section( 'mismo_you_may_missed_section',
        array(
            'priority'       => 20,
            'panel'          => 'mismo_additional_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'You May Missed Setting', 'mismo' )
        )
    );

    /**
     * Toggle field for you may missed section at post page
     *
     * @since 1.0.1
     */
    $wp_customize->add_setting( 'mismo_enable_you_may_missed',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    /**
     * Toggle field for you may missed section
     */
    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_enable_you_may_missed',
            array(
                'label'         => __( 'Show You May Missed Posts', 'mismo' ),
                'section'       => 'mismo_you_may_missed_section',
                'settings'      => 'mismo_enable_you_may_missed',
                'priority'      => 5,
            )
        )
    );
    
    /**
     * Text field for you may missed section
     *
     * @since 1.0.1
     */
    $wp_customize->add_setting(
        'you_may_missed_title',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => __( 'You May Missed', 'mismo' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'you_may_missed_title',
        array(
            'label'         => __( 'You May Missed Section Title', 'mismo' ),
            'type'          => 'text',
            'section'       => 'mismo_you_may_missed_section',
            'settings'      => 'you_may_missed_title',
            'priority'      => 10,
            'active_callback'   => 'mismo_enable_you_may_missed_active_callback'
        )
    );

    /**
     * Select field for you may missed orderby
     *
     * @since 1.0.1
     */
    $wp_customize->add_setting(
        'you_may_missed_orderby',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => 'rp_rand_archive',
            'sanitize_callback' => 'mismo_sanitize_select',
        )
    );
    $wp_customize->add_control(
        'you_may_missed_orderby',
        array(
            'label'         => __( 'Post Order', 'mismo' ),
            'section'       => 'mismo_you_may_missed_section',
            'settings'      => 'you_may_missed_orderby',
            'type'          => 'select',
            'priority'      => 15,
            'choices'       => array(
                'rp_date_archive'     => __( 'Latest Posts', 'mismo' ),
                'rp_rand_archive' => __( 'Random Posts', 'mismo' )
            ),
            'active_callback'   => 'mismo_enable_you_may_missed_active_callback'
        )
    );


}