<?php
/**
 * Mismo Theme Customizer to handle all the settings of colors panels.
 *
 * @package Mismo
 */

add_action( 'customize_register', 'mismo_customize_register_color_panel_settings' );

/**
 * Settings for colors panel
 * 
 */
function mismo_customize_register_color_panel_settings( $wp_customize ) {

    $wp_customize->get_section( 'colors' )->panel = 'mismo_color_panel';// Colors Section

    /**
     * Theme Primary Color
     */
    $wp_customize->add_setting( 'mismo_primary_color',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => '#e44d4d',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control( new WP_Customize_Color_Control(
        $wp_customize, 'mismo_primary_color',
            array(
                'label'      => __( 'Primary Color','mismo' ),
                'section'    => 'colors',
                'settings'   => 'mismo_primary_color',
                'priority'   => 50,
            )
        )
    );

    /*--------------------------- ------------------------------ Category Color Section ---------------------------------------------------------------------*/
    /**
	 * Categories Color
	 */
	$wp_customize->add_section( 'mismo_categories_color_section',
        array(
            'priority'       => 20,
            'panel'          => 'mismo_color_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Categories Color', 'mismo' )
        )
    );

    /**
     * Setting for categories color  
     */
    $priority = 5;
    $categories = get_categories( array( 'hide_empty' => 1 ) );

    foreach ( $categories as $category_list ) {
        $wp_customize->add_setting( 'mismo_category_color_'.esc_attr( $category_list->slug ),
            array(
                'capability'        => 'edit_theme_options',
                'default'           => '#e44d4d',
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control(
            $wp_customize, 'mismo_category_color_'.esc_attr( $category_list->slug ),
                array(
                    'label'      => esc_attr( $category_list->name ).' Color',
                    'section'    => 'mismo_categories_color_section',
                    'settings'   => 'mismo_category_color_'.esc_attr( $category_list->slug ),
                    'priority'   => absint( $priority )
                )
            )
        );
        $priority += 5;
    }
}