<?php
/**
 * Mismo Theme Customizer to handle all the settings of design panels.
 *
 * @package Mismo
 */

add_action( 'customize_register', 'mismo_customize_register_design_panel_settings' );

/**
 * Settings for front panel
 * 
 */
function mismo_customize_register_design_panel_settings( $wp_customize ) {

    /*--------------------------------------------------------- Archive Settings ---------------------------------------------------------------------*/
    /** 
	 * Archive Setting
	 */
	$wp_customize->add_section( 'mismo_archive_section',
        array(
            'priority'       => 5,
            'panel'          => 'mismo_design_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Archive Setting', 'mismo' )
        )
    );

    /**
     * Radio image field for Archive Sidebar Layout
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_archive_sidebar_layout',
        array(
            'default'           => 'right-sidebar',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control( new Mismo_Control_Radio_Image(
        $wp_customize, 'mismo_archive_sidebar_layout',
            array(
                'label'         => __( 'Sidebar Layout', 'mismo' ),
                'description'   => __( 'Choose from available layouts', 'mismo' ),
                'section'       => 'mismo_archive_section',
                'settings'      => 'mismo_archive_sidebar_layout',
                'priority'      => 5,
                'choices'  => array(
                    'right-sidebar'  => get_template_directory_uri() . '/assets/images/right-sidebar.png',
                    'left-sidebar' 	 => get_template_directory_uri() . '/assets/images/left-sidebar.png',
                    'no-sidebar'  => get_template_directory_uri() . '/assets/images/no-sidebar.png',
                    'no-sidebar-center'  => get_template_directory_uri() . '/assets/images/no-sidebar-center.png',
                ),
            )
        )
    );

    /**
     * Radio image field for Archive Style Layout
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_archive_style_layout',
        array(
            'default'           => 'list-style',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control( new Mismo_Control_Radio_Image(
        $wp_customize, 'mismo_archive_style_layout',
            array(
                'label'         => __( 'Archive Style', 'mismo' ),
                'description'   => __( 'Choose from available layouts', 'mismo' ),
                'section'       => 'mismo_archive_section',
                'settings'      => 'mismo_archive_style_layout',
                'priority'      => 10,
                'choices'  => array(
                    'list-style'  => get_template_directory_uri() . '/assets/images/archive-list-layout.png',
                    'grid-style' 	 => get_template_directory_uri() . '/assets/images/archive-grid-layout.png',
                ),
            )
        )
    );

    /**
     * Text field for archive read more txt.
     * 
     */
    $wp_customize->add_setting( 'mismo_archive_read_more_text',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => __( 'Read More', 'mismo' ),
            'sanitize_callback' => 'wp_kses_post'
        )
    );

    $wp_customize->add_control( 'mismo_archive_read_more_text', array(
        'type'			=> 'text',
        'label'    => esc_html__( 'Read More Text', 'mismo' ),
        'section'       => 'mismo_archive_section',
        'priority'      => 15,
    ) );

    /*--------------------------------------------------------- Post Setting ---------------------------------------------------------------------*/
    /** 
	 * Post Setting
	 */
	$wp_customize->add_section( 'mismo_post_section',
        array(
            'priority'       => 10,
            'panel'          => 'mismo_design_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Post Setting', 'mismo' )
        )
    );

    /**
     * Radio image field for Post Sidebar Layout
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_post_sidebar_layout',
        array(
            'default'           => 'right-sidebar',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control( new Mismo_Control_Radio_Image(
        $wp_customize, 'mismo_post_sidebar_layout',
            array(
                'label'         => __( 'Sidebar Layout', 'mismo' ),
                'description'   => __( 'Choose from available layouts', 'mismo' ),
                'section'       => 'mismo_post_section',
                'settings'      => 'mismo_post_sidebar_layout',
                'priority'      => 5,
                'choices'  => array(
                    'right-sidebar'  => get_template_directory_uri() . '/assets/images/right-sidebar.png',
                    'left-sidebar' 	 => get_template_directory_uri() . '/assets/images/left-sidebar.png',
                    'no-sidebar'  => get_template_directory_uri() . '/assets/images/no-sidebar.png',
                    'no-sidebar-center'  => get_template_directory_uri() . '/assets/images/no-sidebar-center.png',
                ),
            )
        )
    );

    /**
     * Toggle field for author info section at post page
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_enable_author_info',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    /**
     * Toggle field for Author Info
     */
    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_enable_author_info',
            array(
                'label'         => __( 'Show Author Info', 'mismo' ),
                'section'       => 'mismo_post_section',
                'settings'      => 'mismo_enable_author_info',
                'priority'      => 15,
            )
        )
    );

    /**
     * Toggle field for related posts section at post page
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_enable_related_posts',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    /**
     * Toggle field for Related Posts
     */
    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_enable_related_posts',
            array(
                'label'         => __( 'Show Related Posts', 'mismo' ),
                'section'       => 'mismo_post_section',
                'settings'      => 'mismo_enable_related_posts',
                'priority'      => 15,
            )
        )
    );
    
    /**
     * Text field for related posts section
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting(
        'related_posts_title',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => __( 'Related Posts', 'mismo' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'related_posts_title',
        array(
            'label'         => __( 'Related Posts Title', 'mismo' ),
            'type'          => 'text',
            'section'       => 'mismo_post_section',
            'settings'      => 'related_posts_title',
            'priority'      => 20,
            'active_callback'   => 'mismo_enable_related_posts_active_callback'
        )
    );

    /**
     * Select field for related post orderby
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting(
        'mismo_related_posts_orderby',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => 'rp_rand',
            'sanitize_callback' => 'mismo_sanitize_select',
        )
    );
    $wp_customize->add_control(
        'mismo_related_posts_orderby',
        array(
            'label'         => __( 'Post orderby', 'mismo' ),
            'section'       => 'mismo_post_section',
            'settings'      => 'mismo_related_posts_orderby',
            'type'          => 'select',
            'priority'      => 30,
            'choices'       => array(
                'rp_date'     => __( 'Default', 'mismo' ),
                'rp_rand' => __( 'Random', 'mismo' )
            ),
            'active_callback'   => 'mismo_enable_related_posts_active_callback'
        )
    );

    /*--------------------------------------------------------- Page Setting ---------------------------------------------------------------------*/
    /** 
	 * Page Setting
	 */
	$wp_customize->add_section( 'mismo_page_section',
        array(
            'priority'       => 15,
            'panel'          => 'mismo_design_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Page Setting', 'mismo' )
        )
    );

    /**
     * Radio image field for Page Sidebar Layout
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_page_sidebar_layout',
        array(
            'default'           => 'right-sidebar',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control( new Mismo_Control_Radio_Image(
        $wp_customize, 'mismo_page_sidebar_layout',
            array(
                'label'         => __( 'Sidebar Layout', 'mismo' ),
                'description'   => __( 'Choose from available layouts', 'mismo' ),
                'section'       => 'mismo_page_section',
                'settings'      => 'mismo_page_sidebar_layout',
                'priority'      => 5,
                'choices'  => array(
                    'right-sidebar'     => get_template_directory_uri() . '/assets/images/right-sidebar.png',
                    'left-sidebar' 	    => get_template_directory_uri() . '/assets/images/left-sidebar.png',
                    'no-sidebar'        => get_template_directory_uri() . '/assets/images/no-sidebar.png',
                    'no-sidebar-center' => get_template_directory_uri() . '/assets/images/no-sidebar-center.png',
                ),
            )
        )
    );

    /*-------------------------------------------------------------------- 404 Page Settings Section ----------------------------------------------------------------*/
	/**
	 * 404 Page Settings
	 */
	$wp_customize->add_section( 'mismo_section_pnf_settings',
        array(
            'priority'       => 20,
            'panel'          => 'mismo_design_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( '404 Page Settings', 'mismo' )
        )
    );

    /**
     * Toggle field for Enable/Disable latest posts section at 404 page
     */
    $wp_customize->add_setting( 'mismo_enable_pnf_latest_posts',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_enable_pnf_latest_posts',
            array(
                'label'         => __( 'Enable Latest Posts', 'mismo' ),
                'section'       => 'mismo_section_pnf_settings',
                'settings'      => 'mismo_enable_pnf_latest_posts',
                'priority'      => 40,
            )
        )
    );

    /**
     * Text field for latest posts section title
     */
    $wp_customize->add_setting( 'mismo_pnf_latest_title',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => esc_html__( 'You May Find Here', 'mismo' ),
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control( 'mismo_pnf_latest_title', array(
        'type'			=> 'text',
        'label'    => esc_html__( 'Section Title', 'mismo' ),
        'section'       => 'mismo_section_pnf_settings',
        'priority'      => 45,
        'active_callback' => 'mismo_enable_pnf_latest_posts_active_callback',
    ) );
}