<?php
/**
 * Mismo Theme Customizer to handle all the settings of footer panel.
 *
 * @package Mismo
 */

add_action( 'customize_register', 'mismo_customize_register_footer_panel_settings' );

/**
 * Settings for Footer panel
 * 
 */
function mismo_customize_register_footer_panel_settings( $wp_customize ) {

    /*--------------------------------------------------------- Footer Widget Area ---------------------------------------------------------------------*/
    /** 
	 * Footer Widget Area
	 */
	$wp_customize->add_section( 'mismo_footer_widget_section',
        array(
            'priority'       => 5,
            'panel'          => 'mismo_footer_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Footer Widget Area', 'mismo' )
        )
    );

    /**
     * Footer Widget Area Option
     */
    $wp_customize->add_setting( 'mismo_footer_widget_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    /**
     * Toggle field for Footer Widget Area
     */
    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_footer_widget_option',
            array(
                'label'         => __( 'Show Footer Widget Area', 'mismo' ),
                'section'       => 'mismo_footer_widget_section',
                'settings'      => 'mismo_footer_widget_option',
                'priority'      => 5,
            )
        )
    );

    /**
     * Radio image field for Footer widget Layout
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_footer_widget_layout',
        array(
            'default'           => 'four-column',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control( new Mismo_Control_Radio_Image(
        $wp_customize, 'mismo_footer_widget_layout',
            array(
                'label'         => __( 'Footer Widget Layout', 'mismo' ),
                'description'   => __( 'Choose from available layouts', 'mismo' ),
                'section'       => 'mismo_footer_widget_section',
                'settings'      => 'mismo_footer_widget_layout',
                'active_callback'=> 'mismo_footer_widget_option_active_callback',
                'priority'      => 10,
                'choices'  => array(
                    'one-column'  	 => get_template_directory_uri() . '/assets/images/one-column.png',
                    'two-column' 	 => get_template_directory_uri() . '/assets/images/two-column.png',
                    'three-column'   => get_template_directory_uri() . '/assets/images/three-column.png',
                    'four-column'    => get_template_directory_uri() . '/assets/images/four-column.png'
                ),
            )
        )
    );
    /*--------------------------------------------------------- Bottom Footer Widget Area ---------------------------------------------------------------------*/
    /** 
	 * Bottom Footer Widget Area
	 */
	$wp_customize->add_section( 'mismo_bottom_footer_widget_section',
        array(
            'priority'       => 10,
            'panel'          => 'mismo_footer_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Bottom Footer widget Area', 'mismo' )
        )
    );

    /**
     * Toggle field for Bottom Footer Widget Area
     */
    $wp_customize->add_setting( 'mismo_bottom_footer_widget_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_bottom_footer_widget_option',
            array(
                'label'         => __( 'Show Bottom Footer Widget Area', 'mismo' ),
                'section'       => 'mismo_bottom_footer_widget_section',
                'settings'      => 'mismo_bottom_footer_widget_option',
                'priority'      => 5,
            )
        )
    );

    /**
     * Radio image field for Bottom Footer widget Layout
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_bottom_footer_widget_layout',
        array(
            'default'           => 'three-column',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control( new Mismo_Control_Radio_Image(
        $wp_customize, 'mismo_bottom_footer_widget_layout',
            array(
                'label'         => __( 'Bottom Footer Widget Layout', 'mismo' ),
                'description'   => __( 'Choose from available layouts', 'mismo' ),
                'section'       => 'mismo_bottom_footer_widget_section',
                'settings'      => 'mismo_bottom_footer_widget_layout',
                'active_callback'=> 'mismo_bottom_footer_widget_option_active_callback',
                'priority'      => 10,
                'choices'  => array(
                    'one-column'  	 => get_template_directory_uri() . '/assets/images/one-column.png',
                    'two-column' 	 => get_template_directory_uri() . '/assets/images/two-column.png',
                    'three-column'   => get_template_directory_uri() . '/assets/images/three-column.png',
                ),
            )
        )
    );
    /*--------------------------------------------------------- Bottom Footer Setting ---------------------------------------------------------------------*/
    /** 
	 * Bottom Footer Setting
	 */
	$wp_customize->add_section( 'mismo_bottom_section',
        array(
            'priority'       => 15,
            'panel'          => 'mismo_footer_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Bottom Footer Setting', 'mismo' )
        )
    );

    /**
     * Text field for copyright text.
     * 
     */
    $wp_customize->add_setting( 'mismo_bottom_section_copyright_txt',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => __( 'Copyright', 'mismo' ),
            'sanitize_callback' => 'wp_kses_post'
        )
    );

    $wp_customize->add_control( 'mismo_bottom_section_copyright_txt', array(
        'type'			=> 'text',
        'label'         => esc_html__( 'Copyright Text', 'mismo' ),
        'section'       => 'mismo_bottom_section',
        'priority'      => 20,
    ) );
}