<?php
/**
 * Mismo Theme Customizer to handle all the settings of general panels.
 *
 * @package Mismo
 */

add_action( 'customize_register', 'mismo_customize_register_general_panel_settings' );

/**
 * Settings for general panel
 * 
 */
function mismo_customize_register_general_panel_settings( $wp_customize ) {

    $wp_customize->get_section( 'title_tagline' )->panel = 'mismo_general_panel'; // Site Identity Section
    $wp_customize->get_section( 'static_front_page' )->panel = 'mismo_general_panel'; // Homepage Settings Section

    /*--------------------------------------------------------- Site Setting Section ---------------------------------------------------------------------*/
    /** 
	 * Site Setting Section
	 */
	$wp_customize->add_section( 'mismo_section_site_setting',
        array(
            'priority'       => 15,
            'panel'          => 'mismo_general_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Site Setting', 'mismo' )
        )
    );

    /**
     * Mismo Preloader Option
     */
    $wp_customize->add_setting( 'mismo_preloader_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_preloader_option',
            array(
                'label'         => __( 'Enable Preloader', 'mismo' ),
                'section'       => 'mismo_section_site_setting',
                'settings'      => 'mismo_preloader_option',
                'priority'      => 10,
            )
        )
    );

    /**
     * Mismo WOw Animation Option
     */
    $wp_customize->add_setting( 'mismo_animation_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_animation_option',
            array(
                'label'         => __( 'Enable Wow animation', 'mismo' ),
                'section'       => 'mismo_section_site_setting',
                'settings'      => 'mismo_animation_option',
                'priority'      => 15,
            )
        )
    );

    /**
     * Radio image field for Site Layout
     *
     * @since 1.0.0
     */
    $wp_customize->add_setting( 'mismo_site_layout',
        array(
            'default'           => 'full-layout',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control( new Mismo_Control_Radio_Image(
        $wp_customize, 'mismo_site_layout',
            array(
                'label'         => __( 'Site Layout', 'mismo' ),
                'description'   => __( 'Choose from available layouts', 'mismo' ),
                'section'       => 'mismo_section_site_setting',
                'settings'      => 'mismo_site_layout',
                'priority'      => 50,
                'choices'  => array(
                    'full-layout'           => get_template_directory_uri() . '/assets/images/full-width.png',
                    'boxed-layout' 	        => get_template_directory_uri() . '/assets/images/boxed-layout.png',
                    'full-screen-layout'    => get_template_directory_uri() . '/assets/images/full-screen-layout.png',
                ),
            )
        )
    );
}