<?php
/**
 * Mismo Theme Customizer to handle all the settings of header panel.
 *
 * @package Mismo
 */

add_action( 'customize_register', 'mismo_customize_register_header_panel_settings' );

/**
 * Settings for header panel
 * 
 */
function mismo_customize_register_header_panel_settings( $wp_customize ) {
    
    /*--------------------------------------------------------- Top Header Section ---------------------------------------------------------------------*/
    /** 
	 * Top Header Settings Section
	 */
	$wp_customize->add_section( 'mismo_section_top_header',
        array(
            'priority'       => 5,
            'panel'          => 'mismo_header_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Top Header', 'mismo' )
        )
    );

    /* 
     * Show/Hide Top header Sticky Sidebar.
     */
    $wp_customize->add_setting( 'mismo_header_sticky_sidebar_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_header_sticky_sidebar_option',
            array(
                'label'         => __( 'Show Header Sticky Sidebar', 'mismo' ),
                'section'       => 'mismo_section_top_header',
                'settings'      => 'mismo_header_sticky_sidebar_option',
                'priority'      => 5,
            )
        )
    );

    /* 
     * Show/Hide Top header.
     */
    $wp_customize->add_setting( 'mismo_highlight_post_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_highlight_post_option',
            array(
                'label'         => __( 'Show Highlight Post', 'mismo' ),
                'section'       => 'mismo_section_top_header',
                'settings'      => 'mismo_highlight_post_option',
                'priority'      => 25,
            )
        )
    );

    /**
     * Highlight post title
     */
    $wp_customize->add_setting( 'mismo_highlight_post_title', array(
        'default'           => __( 'Just Posted', 'mismo' ),
        'sanitize_callback' => 'sanitize_text_field'
   ) );

   $wp_customize->add_control( new WP_Customize_Control(
       $wp_customize,
       'mismo_highlight_post_title',
           array(
               'label'    => __( 'Highlight Post Title', 'mismo' ),
               'section'  => 'mismo_section_top_header',
               'settings' => 'mismo_highlight_post_title',
               'type'     => 'text',
               'priority' => 30,
               'active_callback' => 'mismo_highlight_post_option_active_callback'
           )
       )
   );

   

   /*---------------------------------------------------------- Header Section -----------------------------------------------------------------------------*/
    /** 
	 * Header Settings Section
	 */
	$wp_customize->add_section( 'mismo_section_header',
        array(
            'priority'       => 10,
            'panel'          => 'mismo_header_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Header Section', 'mismo' )
        )
    );

    /**
     * Follow Icons option
     */
    $wp_customize->add_setting( 'mismo_follow_icons_option', array(
        'capability' => 'edit_theme_options',
        'default'    => false,
        'sanitize_callback' => 'mismo_sanitize_checkbox',
    ) );
      
    $wp_customize->add_control( 'mismo_follow_icons_option', array(
        'type'      => 'checkbox',
        'section'   => 'mismo_section_header',
        'label'     => __( 'Follow Icons', 'mismo' ),
        'description' => __( 'Add Follow us Icon from Additional Panel', 'mismo' ),
        'priority'    => 10
    ) );


    /**
     * Search Icon option
     */
    $wp_customize->add_setting( 'mismo_search_icon_option', array(
        'capability' => 'edit_theme_options',
        'default'    => false,
        'sanitize_callback' => 'mismo_sanitize_checkbox',
    ) );
      
    $wp_customize->add_control( 'mismo_search_icon_option', array(
        'type'      => 'checkbox',
        'section'   => 'mismo_section_header',
        'label'     => __( 'Search Icon', 'mismo' ),
        'description' => __( 'Check To Show Search Icon.', 'mismo' ),
        'priority'    => 30
    ) );

    /*---------------------------------------------------------- Trending Tags Section -----------------------------------------------------------------------------*/
    /** 
	 * Tending Tags Settings Section
	 */
	$wp_customize->add_section( 'mismo_section_trending_tag',
        array(
            'priority'       => 15,
            'panel'          => 'mismo_header_panel',
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Trending Tags Section', 'mismo' )
        )
    );

    /**
     * Trending Tags Section Option
     */
    $wp_customize->add_setting( 'mismo_trending_tags_sec_option',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => true,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_trending_tags_sec_option',
            array(
                'label'         => __( 'Show Trending Tags Section', 'mismo' ),
                'section'       => 'mismo_section_trending_tag',
                'settings'      => 'mismo_trending_tags_sec_option',
                'priority'      => 5,
            )
        )
    );

    /**
     * Toggle field for Enable/Disable trending tags.
     * 
     */
    $wp_customize->add_setting( 'mismo_enable_trending_tags_items',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => false,
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( new Mismo_Control_Toggle(
        $wp_customize, 'mismo_enable_trending_tags_items',
            array(
                'label'         => esc_html__( 'Show Trending Tags', 'mismo' ),
                'description'   => esc_html__( 'Trending Tags shows the popular tags.', 'mismo' ),
                'section'       => 'mismo_section_trending_tag',
                'settings'      => 'mismo_enable_trending_tags_items',
                'priority'      => 10,
                'active_callback' => 'mismo_trending_tags_sec_option_active_callback',
            )
        )
    );



    /**
     * checkox for before icon in tags items.
     */
    $wp_customize->add_setting( 'mismo_enable_trending_tags_items_before_icon',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => '1',
            'sanitize_callback' => 'mismo_sanitize_checkbox'
        )
    );

    $wp_customize->add_control( 'mismo_enable_trending_tags_items_before_icon', array(
        'type'			=> 'checkbox',
        'label'         => esc_html__( 'Add Icon Before Tag', 'mismo' ),
        'description'   => esc_html__( 'Show/Hide Hash Icon before tag.', 'mismo' ),
        'section'       => 'mismo_section_trending_tag',
        'priority'      => 15,
        'active_callback' => 'mismo_trending_tags_sec_and_tags_items_option_active_callback',

    ) );

    /**
    * Text field for trending tags items label.
    * 
    */
    $wp_customize->add_setting( 'mismo_enable_trending_tags_items_label',
        array(
            'capability'        => 'edit_theme_options',
            'default'           => esc_html__( 'Trending Now', 'mismo' ),
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control( 'mismo_enable_trending_tags_items_label', array(
        'type'			=> 'text',
        'label'         => esc_html__( 'Trending Label', 'mismo' ),
        'section'       => 'mismo_section_trending_tag',
        'priority'      => 20,
        'active_callback' => 'mismo_trending_tags_sec_and_tags_items_option_active_callback',
    ) );

    /**
    * Select field of trending tags items orderby.
    * 
    */
    $wp_customize->add_setting( 'mismo_enable_trending_tags_items_orderby', array(
        'capability' 	=> 'edit_theme_options',
        'default' 		=> '',
        'sanitize_callback' => 'mismo_sanitize_select',
    ) );

    $wp_customize->add_control( 'mismo_enable_trending_tags_items_orderby', array(
        'type'      => 'select',
        'label'     => esc_html__( 'Tags Orderby', 'mismo' ),
        'section'   => 'mismo_section_trending_tag',
        'default'   => '',
        'priority'  => 25,
        'choices'   => array(
            ''	     => esc_html__( 'Default', 'mismo' ),
            'count'  => esc_html__( 'Count', 'mismo' ),
        ),
        'active_callback' => 'mismo_trending_tags_sec_and_tags_items_option_active_callback',
    ) );

    /**
     * Number field of trending tags items count.
     * 
     */
    $wp_customize->add_setting( 'mismo_trending_tags_items_count', array(
        'capability' 	=> 'edit_theme_options',
        'default' 		=> '5',
        'sanitize_callback' => 'absint',
    ) );

    $wp_customize->add_control( 'mismo_trending_tags_items_count', array(
        'type'     => 'number',
        'label'    => esc_html__( 'Tags Count', 'mismo' ),
        'section'  => 'mismo_section_trending_tag',
        'priority' => 30,
        'active_callback' => 'mismo_trending_tags_sec_and_tags_items_option_active_callback',
    ) );

    /**
     * Address Text
     */
	$wp_customize->add_setting( 'mismo_header_address_text', array(
        'default'           => __( 'Street-1, NY', 'mismo' ),
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    $wp_customize->add_control( new WP_Customize_Control(
       $wp_customize,
       'mismo_header_address_text',
            array(
               'label'    => __( 'Address Text', 'mismo' ),
               'section'  => 'mismo_section_trending_tag',
               'settings' => 'mismo_header_address_text',
               'type'     => 'text',
               'priority' => 35,
               'active_callback' => 'mismo_trending_tags_sec_option_active_callback'
            )
        )
    );

    /**
     * Email Text
     */
	$wp_customize->add_setting( 'mismo_header_email_text', array(
        'default'           => __( 'mismo@example.com', 'mismo' ),
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    $wp_customize->add_control( new WP_Customize_Control(
       $wp_customize,
       'mismo_header_email_text',
            array(
               'label'    => __( 'Email Text', 'mismo' ),
               'section'  => 'mismo_section_trending_tag',
               'settings' => 'mismo_header_email_text',
               'type'     => 'text',
               'priority' => 40,
               'active_callback' => 'mismo_trending_tags_sec_option_active_callback'
            )
        )
    );

    /**
     * Contact Number
     */
	$wp_customize->add_setting( 'mismo_header_contact_number', array(
        'default'           => __( '+999-123456789', 'mismo' ),
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    $wp_customize->add_control( new WP_Customize_Control(
       $wp_customize,
       'mismo_header_contact_number',
            array(
               'label'    => __( 'Contact Number', 'mismo' ),
               'section'  => 'mismo_section_trending_tag',
               'settings' => 'mismo_header_contact_number',
               'type'     => 'text',
               'priority' => 45,
               'active_callback' => 'mismo_trending_tags_sec_option_active_callback'
            )
        )
    );

    /* 
     * Show/Hide Date.
     */
    $wp_customize->add_setting( 'mismo_header_date_option', array(
        'capability' => 'edit_theme_options',
        'default'    => '1',
        'sanitize_callback' => 'mismo_sanitize_checkbox',
    ) );
      
    $wp_customize->add_control( 'mismo_header_date_option', array(
        'type'          => 'checkbox',
        'section'       => 'mismo_section_trending_tag',
        'label'         => __( 'Show date', 'mismo' ),
        'description'   => __( 'This is a option to show/hide current date.', 'mismo' ),
        'priority'      => 50,
        'active_callback' => 'mismo_trending_tags_sec_option_active_callback'
    ) );
}