<?php
/**
 * Dynamic styles
 *
 * @package Mismo
 * 
 * @since 1.0.0
 *
 */

add_action( 'wp_enqueue_scripts', 'mismo_dynamic_styles' );

if ( ! function_exists( 'mismo_dynamic_styles' ) ) :
    
    function mismo_dynamic_styles() {

    	$mismo_primary_color = get_theme_mod( 'mismo_primary_color', '#e44d4d' );
        $mismo_primary_hover_color = mismo_hover_color( $mismo_primary_color, '-50' );
        $get_categories = get_categories( array( 'hide_empty' => 1 ) );

        $output_css = '';
        
        foreach( $get_categories as $category ) {

            $cat_color = get_theme_mod( 'mismo_category_color_'.$category->slug, '#e44d4d' );
            $cat_hover_color = mismo_hover_color( $cat_color, '-40' );
            
            $cat_slug = $category->slug;
            $cat_id = $category->term_id;
            if ( !empty( $cat_color ) ) {

                $output_css .= ".category-button.m-cat-". esc_attr( $cat_slug ) ." a { color: ". esc_attr( $cat_color ) ."}\n";

                $output_css .= ".category-button.m-cat-". esc_attr( $cat_id ) ." a { color: ". esc_attr( $cat_color ) ."}\n";

                $output_css .= ".category-button.m-cat-". esc_attr( $cat_id ) ." a:hover { color: ". esc_attr( $cat_hover_color ) ."}\n";

                 $output_css .= ".category-button.m-cat-". esc_attr( $cat_id ) ." a:after { border-color: ". esc_attr( $cat_color ) ."}\n";

                $output_css .= ".category-button.m-cat-". esc_attr( $cat_id ) ." a:hover::after { border-color: ". esc_attr( $cat_hover_color ) ."}\n";

                $output_css .= "#site-navigation ul li a .menu-item-description { background: ". esc_attr( $mismo_primary_hover_color ) ."}\n";

                $output_css .= "#site-navigation ul li a .menu-item-description:after { border-top-color: ". esc_attr( $mismo_primary_hover_color ) ."}\n";
            }
        }

        $output_css .= "a, a:focus,a:active,.entry-cat .cat-links a:hover,.entry-cat a:hover,.entry-footer a:hover,.comment-author .fn .url:hover,.commentmetadata .comment-edit-link, #cancel-comment-reply-link, #cancel-comment-reply-link:before, .logged-in-as a, .widget li:hover::before,#site-navigation ul li a:hover,.cat-links a:hover,.navigation.pagination .nav-links .page-numbers.current, .navigation.pagination .nav-links a.page-numbers:hover, #footer-menu li a:hover, .entry-meta a:hover, .post-info-wrap .entry-meta a:hover, .breadcrumbs .trail-items li a:hover,  .entry-title a:hover, .widget_tag_cloud .tagcloud a:hover,.widget_archive a:hover, .widget_categories a:hover, .widget_recent_entries a:hover, .widget_meta a:hover, .widget_recent_comments li:hover, .widget_rss li:hover, .widget_pages li a:hover, .widget_nav_menu li a:hover,.timeline-widget-wrap .post-title a:hover{ color: ". esc_attr( $mismo_primary_color ) ."}\n";

         $output_css .= ".top-stories-post-wrapper .post-title a:hover, .carousel-controls span:hover, #colophon a:hover, #colophon .widget_archive a:hover, #colophon .widget_categories a:hover, #colophon .widget_recent_entries a:hover, #colophon .widget_meta a:hover, #colophon .widget_pages li a:hover, #colophon .widget_nav_menu li a:hover, #m-follow-icons-wrapper i, #m-search-wrapper .search-form-open:hover, #m-search-wrapper .m-search-form:hover, #m-search-wrapper .search-form:hover, #m-search-wrapper .search-close:hover, #m-main-header #m-follow-icons-wrapper i:hover, .menu-toggle i:hover, #m-scrollup:hover, .head-tags-links a:hover::before, .trending-wrapper .head-tags-links a:hover, .banner-slider-wrap .banner-btn a:hover, .error404 .error-image i, #site-navigation ul li:hover > a,#site-navigation ul li.current-menu-item > a,#site-navigation ul li.current_page_ancestor > a,#site-navigation ul li.current_page_item > a,#site-navigation ul li.current-menu-ancestor > a,#site-navigation ul li.focus>a, .trending-wrapper.tag-before-icon .head-tags-links a:hover::before,.trending-wrapper .head-tags-links a:hover, .post-title.medium-size a:hover, .post-title.small-size a:hover, .post-title.large-size a:hover{ color: ". esc_attr( $mismo_primary_color ) ."}\n";

        $output_css .= ".widget_search .search-submit,.widget_search .search-submit:hover,.navigation.pagination .nav-links .page-numbers.current, .navigation.pagination .nav-links a.page-numbers:hover,.navigation .nav-links a, .bttn, button, input[type=button], input[type=reset], input[type=submit], .comment-list .comment-body, #colophon .category-button a:hover:after, #m-scrollup { border-color: ". esc_attr( $mismo_primary_color ) ."}\n";

        $output_css .= ".lSSlideOuter .lSPager.lSpg > li.active a, .lSSlideOuter .lSPager.lSpg > li:hover a, .navigation .nav-links a, .bttn, button, input[type=button], input[type=reset], input[type=submit], .navigation .nav-links a:hover, .bttn:hover,input[type=button]:hover, input[type=reset]:hover, input[type=submit]:hover, .navigation .nav-links a,.bttn,button,input[type='button'],input[type='reset'],input[type='submit']{ background: ". esc_attr( $mismo_primary_color ) ."}\n";

        $output_css .= ".edit-link .post-edit-link,.reply .comment-reply-link,.widget_search .search-submit, .archive--grid-style #primary article .entry-meta, #m-scrollup, .header-sticky-sidebar-close,#m-top-header, .header-sticky-sidebar-content .widget-title, #content .widget-title,.header-sticky-sidebar-content .widget-title::after, #content .widget-title::after,#m-widget-tab li,#content .mismo_social_media .widget-title,#colophon .widget-title::before, #preloader-background .sk-spinner-pulse,article .mismo-bg-img::before, article.format-gallery .post-format-gallery li::before,.timeline-widget-wrap .trending_number span { background: ". esc_attr( $mismo_primary_color ) ."}\n";

        $output_css .= "#m-widget-tab li.ui-tabs-active, #m-widget-tab li.ui-tabs-tab:hover,.navigation .nav-links a:hover,.bttn:hover,button,input[type='button']:hover,input[type='reset']:hover,input[type='submit']:hover{ background: ". esc_attr( $mismo_primary_hover_color ) ."}\n";
                        
        $refine_output_css = mismo_css_strip_whitespace( $output_css );

        wp_add_inline_style( 'mismo-style', $refine_output_css );

    }

endif;