<?php
/**
 * Functions for rendering meta boxes in post/page
 * 
 * @package Mismo
 */

/*----------------------------------------------------------------------------------------------------------------------------------------*/

add_action( 'add_meta_boxes', 'mismo_sidebar_metaboxes', 10, 2 );

function mismo_sidebar_metaboxes() {
    
    add_meta_box(
        'mismo_post_sidebar',
        __( 'Sidebar Layout', 'mismo' ),
        'mismo_sidebar_callback',
        'post',
        'normal',
        'default'
    );
    
    add_meta_box(
        'mismo_page_sidebar',
        __( 'Sidebar Layout', 'mismo' ),
        'mismo_sidebar_callback',
        'page',
        'normal',
        'default'
    );
    
}

/*----------------------------------------------------------------------------------------------------------------------------------------*/
function mismo_sidebar_callback( $post ) {

    // Setup our options.
    $mismo_page_sidebar_option = array(
        'default-sidebar' => array(
            'id'        => 'post-default-sidebar',
            'value'     => 'default-sidebar',
            'label'     => __( 'Default Sidebar', 'mismo' ),
            'thumbnail' => get_template_directory_uri() . '/assets/images/default-sidebar.png'
        ),
        'left-sidebar' => array(
            'id'        => 'post-right-sidebar',
            'value'     => 'left-sidebar',
            'label'     => __( 'Left sidebar', 'mismo' ),
            'thumbnail' => get_template_directory_uri() . '/assets/images/left-sidebar.png'
        ),
        'right-sidebar' => array(
            'id'        => 'post-left-sidebar',
            'value'     => 'right-sidebar',
            'label'     => __( 'Right sidebar', 'mismo' ),
            'thumbnail' => get_template_directory_uri() . '/assets/images/right-sidebar.png'
        ),
        'no-sidebar'    => array(
            'id'        => 'post-no-sidebar',
            'value'     => 'no-sidebar',
            'label'     => __( 'No sidebar Full width', 'mismo' ),
            'thumbnail' => get_template_directory_uri() . '/assets/images/no-sidebar.png'
        ),
        'no-sidebar-center' => array(
            'id'        => 'post-no-sidebar-center',
            'value'     => 'no-sidebar-center',
            'label'     => __( 'No sidebar Content Centered', 'mismo' ),
            'thumbnail' => get_template_directory_uri() . '/assets/images/no-sidebar-center.png'
        )
    );

    // Check for previously set.
    $post_sidebar_layout = get_post_meta( $post->ID, 'mismo_post_sidebar_layout', true );

    // If it is then we use it otherwise set to default.
    $post_sidebar_layout = ( $post_sidebar_layout ) ? $post_sidebar_layout : 'default-sidebar';

    // Create our nonce field.
    wp_nonce_field( 'mismo_nonce_' . basename( __FILE__ ) , 'mismo_sidebar_layout_nonce' );
    ?>
        <div class="mt-meta-options-wrap">
            <div class="buttonset">
                <?php
                    foreach ( $mismo_page_sidebar_option as $field ) {
                ?>
                        <input type="radio" id="<?php echo esc_attr( $field['id'] ); ?>" value="<?php echo esc_attr( $field['value'] ); ?>" name="mismo_post_sidebar_layout" <?php checked( $field['value'], $post_sidebar_layout ); ?> />
                        <label for="<?php echo esc_attr( $field['id'] ); ?>">
                            <span class="screen-reader-text"><?php echo esc_html( $field['label'] ); ?></span>
                            <img src="<?php echo esc_url( $field['thumbnail'] ); ?>" title="<?php echo esc_attr( $field['label'] ); ?>" alt="<?php echo esc_attr( $field['label'] ); ?>" />
                        </label>
                    
                <?php } ?>
            </div><!-- .buttonset -->
        </div><!-- .mt-meta-options-wrap  -->
    <?php
}

/*----------------------------------------------------------------------------------------------------------------------------------------*/
add_action( 'save_post', 'mismo_save_post_meta' );

function mismo_save_post_meta( $post_id ) {

    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST['mismo_sidebar_layout_nonce'] ) && wp_verify_nonce( $_POST['mismo_sidebar_layout_nonce'], 'mismo_nonce_' . basename( __FILE__ ) ) ) ? 'true' : 'false';

    // Exits script depending on save status
    if ( $is_autosave || $is_revision || ! $is_valid_nonce ) {
        return;
    }

    // Check for out input value.
    if ( isset( $_POST['mismo_post_sidebar_layout'] ) ) {
        
        // We validate making sure that the option is something we can expect.
        $value = in_array( $_POST['mismo_post_sidebar_layout'], array( 'no-sidebar', 'left-sidebar', 'right-sidebar', 'no-sidebar-center', 'default-sidebar' ) ) ? $_POST['mismo_post_sidebar_layout'] : 'default-sidebar';
        
        // We update our post meta.
        update_post_meta( $post_id, 'mismo_post_sidebar_layout', $value );
    }
    
}