<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Mismo
 */

if ( !function_exists( 'mismo_post_time' ) ) :

	/**
	 * Prints the time in hour and minute
	 */
	function mismo_post_time() {

		$posted 	 = get_the_time( 'U' );
		$posted_time = human_time_diff( $posted, current_time( 'U' ) ). esc_html__( ' ago', 'mismo' );

		echo '<span class="posted-on"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . esc_html( $posted_time ) . '</a></span>';

	}

endif;

if ( ! function_exists( 'mismo_posted_on' ) ) :

	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function mismo_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);

		echo '<span class="posted-on"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . wp_kses_post( $time_string ) . '</a></span>';

	}

endif;

if ( ! function_exists( 'mismo_posted_by' ) ) :

	/**
	 * Prints HTML with meta information for the current author.
	 */
	function mismo_posted_by() {
		$byline = sprintf(
			/* translators: %s: post author. */
			esc_html_x( 'by %s', 'post author', 'mismo' ),
			'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
		);

		echo '<span class="byline"> ' . $byline . '</span>'; // WPCS: XSS OK.

	}

endif;

if ( ! function_exists( 'mismo_entry_footer' ) ) :

	/**
	 * Prints HTML with meta information for the tags.
	 */
	function mismo_entry_footer() {
		// Hide tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'mismo' ) );
			if ( $tags_list ) {
				echo '<span class="tags-links">' . wp_kses_post( $tags_list ) . '</span>';
			}
		}

		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'mismo' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<span class="edit-link">',
			'</span>'
		);
	}

endif;

if ( ! function_exists( 'mismo_post_comment_links' ) ) :

	/**
	 * Prints HTML with meta information for the comments.
	 */
	function mismo_post_comment_links() {

		if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'mismo' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</span>';
		}

	}

endif;

if ( ! function_exists( 'mismo_post_thumbnail' ) ) :

	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function mismo_post_thumbnail() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ) :
	?>

			<div class="post-thumbnail">
				<?php the_post_thumbnail(); ?>
			</div><!-- .post-thumbnail -->

		<?php else : ?>

		<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
			<?php
			the_post_thumbnail( 'post-thumbnail', array(
				'alt' => the_title_attribute( array(
					'echo' => false,
				) ),
			) );
			?>
		</a>

	<?php
		endif; // End is_singular().
	}

endif;

/*-----------------------------------------------------------------------------------------------------------------------*/

if ( ! function_exists( 'mismo_post_categories_list' ) ) :

	/**
	 * Categories list in multiple color background
	 *
	 * @since 1.0.0
	 */
	function mismo_post_categories_list() {
		global $post;
		$post_id = $post->ID;
		$categories_list = get_the_category($post_id);
		if ( !empty( $categories_list ) ) {
?>
		<ul class="post-cats-list">
			<?php 
				foreach ( $categories_list as $cat_data ) {
					$cat_name = $cat_data->name;
					$cat_id = $cat_data->term_id;
					$cat_link = get_category_link( $cat_id );
			?>
				<li class="category-button m-cat-<?php echo esc_attr( $cat_id ); ?>"><a href="<?php echo esc_url( $cat_link ); ?>"><?php echo esc_html( $cat_name ); ?></a></li>
			<?php 
				}
			?>
		</ul>
<?php
		}
	}

endif;

/*-----------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_category_nav_class' ) ) :
	
	/**
	 * Add cat id in menu class
	 */
	function mismo_category_nav_class( $classes, $item ) {
	    if ( 'category' == $item->object ) {
	        $category = get_category( $item->object_id );
	        $classes[] = 'm-cat-' . $category->term_id;
	    }
	    return $classes;
	}

endif;
add_filter( 'nav_menu_css_class', 'mismo_category_nav_class', 10, 2 );