<?php
/**
 * Widget to show the content of Banner Section
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

class Mismo_Banner extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        $widget_ops = array( 
            'classname'                     => 'mismo_banner',
            'description'                   => __( 'Display front banner and section with a selected posts from selected category.', 'mismo' ),
            'customize_selective_refresh'   => true,
        );
        parent::__construct( 'mismo_banner', __( 'Mismo: Banner', 'mismo' ), $widget_ops );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {

        $fields = array(
            'top_stories_section' => array(
                'mismo_widgets_name'         => 'top_stories_section',
                'mismo_widgets_title'        => __( 'Top Stories Section', 'mismo' ),
                'mismo_widgets_field_type'   => 'heading'
            ),

            'top_stories_option' => array(
                'mismo_widgets_name'         => 'top_stories_option',
                'mismo_widgets_title'        => __( 'Top Stories Option(show/hide)', 'mismo' ),
                'mismo_widgets_description'  => __( 'Displays the latest post', 'mismo' ),
                'mismo_widgets_default'      => '1',
                'mismo_widgets_field_type'   => 'checkbox',
            ),

            'top_stories_label' => array(
                'mismo_widgets_name'         => 'top_stories_label',
                'mismo_widgets_title'        => __( 'Top Stories Label', 'mismo' ),
                'mismo_widgets_default'      => __( 'Top Stories', 'mismo' ),
                'mismo_widgets_field_type'   => 'text',
            ),

            'slider_section' => array(
                'mismo_widgets_name'         => 'slider_section',
                'mismo_widgets_title'        => __( 'Slider Section', 'mismo' ),
                'mismo_widgets_field_type'   => 'heading'
            ),

            'slider_section_cat_slug' => array(
                'mismo_widgets_name'         => 'slider_section_cat_slug',
                'mismo_widgets_title'        => __( 'Select Category For Slider Section', 'mismo' ),
                'mismo_widgets_description'  => __( 'Select category from dropdown options', 'mismo' ),
                'mismo_widgets_field_type'   => 'mismo_category_dropdown',
                'mismo_widget_field_wrapper' => 'slider-cat-enable',
            ),

            'featured_section' => array(
                'mismo_widgets_name'         => 'featured_section',
                'mismo_widgets_title'        => __( 'Featured Section', 'mismo' ),
                'mismo_widgets_field_type'   => 'heading'
            ),

            'featured_section_option' => array(
                'mismo_widgets_name'         => 'featured_section_option',
                'mismo_widgets_title'        => __( 'Featured Section Option(show/hide)', 'mismo' ),
                'mismo_widgets_default'      => '1',
                'mismo_widgets_field_type'   => 'checkbox'
            ),
            
            'featured_section_label' => array(
                'mismo_widgets_name'         => 'featured_section_label',
                'mismo_widgets_title'        => __( 'Featured Section Label', 'mismo' ),
                'mismo_widgets_default'      => __( 'Featured News', 'mismo' ),
                'mismo_widgets_field_type'   => 'text'
            ),

            'featured_section_cat_slug' => array(
                'mismo_widgets_name'         => 'featured_section_cat_slug',
                'mismo_widgets_title'        => __( 'Select Category For Featured Section', 'mismo' ),
                'mismo_widgets_description'  => __( 'Select category from dropdown options', 'mismo' ),
                'mismo_widgets_field_type'   => 'mismo_category_dropdown'
            ),

            'featured_section_post_order' => array(
                'mismo_widgets_name'         => 'featured_section_post_order',
                'mismo_widgets_title'        => __( 'Post Order', 'mismo' ),
                'mismo_widgets_default'      => 'default-order',
                'mismo_widgets_description'  => __( 'Choose by which order to display featured posts', 'mismo' ),
                'mismo_widgets_field_type'   => 'radio',
                'mismo_widgets_field_options' => array(
                    'default-order'      => __( 'Default', 'mismo' ),
                    'random-order'       => __( 'Random', 'mismo' ),
                )
            ),
        );
        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );

        if ( empty( $instance ) ) {
            return ;
        }

        $top_stories_option   = empty( $instance['top_stories_option'] ) ? null : $instance['top_stories_option'];
        $top_stories_label    = empty( $instance['top_stories_label'] ) ? '' : $instance['top_stories_label'];

        $slider_section_cat_slug   = empty( $instance['slider_section_cat_slug'] ) ? null : $instance['slider_section_cat_slug'];

        $featured_section_option   = empty( $instance['featured_section_option'] ) ? null : $instance['featured_section_option'];
        $featured_section_label   = empty( $instance['featured_section_label'] ) ? '' : $instance['featured_section_label'];
        $featured_section_cat_slug  = empty( $instance['featured_section_cat_slug'] ) ? '' : $instance['featured_section_cat_slug'];
        $featured_section_post_order  = empty( $instance['featured_section_post_order'] ) ? '' : $instance['featured_section_post_order'];

        if ( true == $top_stories_option && true == $featured_section_option ) {
            $mismo_banner_class = 'default-banner--width';
        } elseif ( false == $top_stories_option && true == $featured_section_option ) {
            $mismo_banner_class = 'left-full-banner--width';
        } elseif ( true == $top_stories_option && false == $featured_section_option ) {
            $mismo_banner_class = 'right-full-banner--width';
        } else {
            $mismo_banner_class = 'full-banner--width';
        }

        echo $before_widget;
?>
        <div class="banner-section-wrapper mt-clearfix <?php echo esc_html( $mismo_banner_class ); ?>">
            <?php
                if ( true == $top_stories_option ) {
                    mismo_banner_top_stories( $top_stories_label );
                }
                    
                mismo_banner_slider( $slider_section_cat_slug );

                if ( true == $featured_section_option ) {
                    mismo_banner_featured_section( $featured_section_label,$featured_section_cat_slug, $featured_section_post_order );
                }
            ?>
        </div><!-- .banner-section-wrapper -->
<?php
        echo $after_widget;
    }


    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    mismo_widgets_updated_field_value()      defined in m-widget-fields.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            extract( $widget_field );

            // Use helper function to get updated field values
            $instance[$mismo_widgets_name] = mismo_widgets_updated_field_value( $widget_field, $new_instance[$mismo_widgets_name] );
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses    mismo_widgets_show_widget_field()        defined in m-widget-fields.php
     */
    public function form( $instance ) {

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            // Make array elements available as variables
            extract( $widget_field );

            if ( empty( $instance ) && isset( $mismo_widgets_default ) ) {
                $mismo_widgets_field_value = $mismo_widgets_default;
            } elseif ( empty( $instance ) ) {
                $mismo_widgets_field_value = '';
            } else {
                $mismo_widgets_field_value = wp_kses_post( $instance[$mismo_widgets_name] );
            }
            mismo_widgets_show_widget_field( $this, $widget_field, $mismo_widgets_field_value );
        }
    }

}
