<?php
/**
 * Widget to show the content of Carousel Grid Posts.
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

class Mismo_Carousel_Grid_Posts extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        $widget_ops = array( 
            'classname'                     => 'mismo_carousel_grid_posts',
            'description'                   => __( 'Display posts in carousel layout.', 'mismo' ),
            'customize_selective_refresh'   => true,
        );
        parent::__construct( 'mismo_carousel_grid_posts', __( 'Mismo: Carousel Grid Posts', 'mismo' ), $widget_ops );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {

        $fields = array(
            'carousel_grid_posts_section' => array(
                'mismo_widgets_name'         => 'carousel_grid_posts_section',
                'mismo_widgets_title'        => __( 'Carousel Posts', 'mismo' ),
                'mismo_widgets_field_type'   => 'heading'
            ),

            'carousel_grid_posts_label' => array(
                'mismo_widgets_name'         => 'carousel_grid_posts_label',
                'mismo_widgets_title'        => __( 'Carousel Title', 'mismo' ),
                'mismo_widgets_field_type'   => 'text'
            ),
        );

        for ( $i=0; $i<3; $i++ ) {
            $fields[ 'carousel_grid_section_cat_slug_'.$i ] = array(
                'mismo_widgets_name'         => 'carousel_grid_section_cat_slug_'.$i,
                'mismo_widgets_title'        => __( 'Select Category ', 'mismo' ).( $i+1 ),
                'mismo_widgets_description'  => __( 'Select category from dropdown options', 'mismo' ),
                'mismo_widgets_field_type'   => 'mismo_category_dropdown',
            );
        }
        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );

        if ( empty( $instance ) ) {
            return ;
        }

        $carousel_grid_posts_label = empty( $instance['carousel_grid_posts_label'] ) ? '' : $instance['carousel_grid_posts_label'];

        echo $before_widget;
?>
            <div class="m-carousel-grid-posts-wrapper <?php if ( empty( $carousel_grid_posts_label ) ) { echo 'no-title'; } ?>">
                <div class="carousel-title-wrapper">
                <?php
                    if ( !empty( $carousel_grid_posts_label ) ) {
                        echo wp_kses_post( $before_title ).esc_html( $carousel_grid_posts_label ).wp_kses_post( $after_title );
                    }
                ?>
                    <div class="right-side-title">
                        <ul class="carousel-cat-title-list">
                        <?php
                            for ( $i=0; $i<3; $i++ ) {
                                $carousel_section_cat_slug = empty( $instance['carousel_grid_section_cat_slug_'. $i] ) ? '' : $instance['carousel_grid_section_cat_slug_'. $i];
                                if ( ! empty( $carousel_section_cat_slug ) ) {
                        ?>
                                    <li class="category-button m-cat-<?php echo esc_attr( $carousel_section_cat_slug ); ?>"><a href="#<?php echo esc_attr( $carousel_section_cat_slug ); ?>" class="cat-title-list"><?php echo esc_html( $carousel_section_cat_slug ); ?></a></li>
                        <?php
                                }
                            }
                        ?>
                        </ul>
                        <div class="lSAction carousel-controls">
                            <span class="lSPrev">
                                <i class="fa fa-long-arrow-left" aria-hidden="true"></i>
                            </span>
                            <span class="lSNext">
                                <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                            </span>
                        </div><!--carousel-controls -->
                    </div><!-- right-side-title -->
                </div><!-- carousel-title-wrapper -->
                <?php
                    for ( $i=0; $i<3; $i++ ) {
                        $carousel_section_cat_slug = empty( $instance['carousel_grid_section_cat_slug_'. $i] ) ? '' : $instance['carousel_grid_section_cat_slug_'. $i];
                        if ( ! empty( $carousel_section_cat_slug ) ) {
                            $mc_posts_args = array(
                                'post_type'         => 'post',
                                'category_name'     => $carousel_section_cat_slug,
                                'posts_per_page'    => 5,
                            );
                            $mc_posts_query = new WP_Query( $mc_posts_args );
                            if ( $mc_posts_query -> have_posts() ):
                        ?>
                                <div id="<?php echo esc_attr( $carousel_section_cat_slug ); ?>" class="m-carousel-grid-posts-content cS-hidden">
                                <?php
                                    $wow_delay = 0.2;
                                    while ( $mc_posts_query -> have_posts() ): $mc_posts_query -> the_post();
                                    if ( has_post_thumbnail() ) {
                                        $thumbail_class = 'has-thumbnail';
                                    } else {
                                        $thumbail_class = '';
                                    }
                                ?>
                                        <div class="carousel-posts wow fadeInUp <?php echo esc_attr( $thumbail_class ); ?>" data-wow-delay="<?php echo esc_attr( $wow_delay ).'s' ?>">
                                            <?php get_template_part( 'template-parts/widgets-layouts/m-carousel/content', 'carousel' ); ?>
                                        </div>
                                <?php
                                    $wow_delay += 0.2;
                                    endwhile;
                                ?>
                                </div><!-- .m-carousel-grid-posts-content -->
                <?php
                            endif;
                            wp_reset_postdata();
                        }
                    }
                ?>
            </div><!-- .m-carousel-grid-posts-wrapper -->
<?php
        echo $after_widget;
    }


    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    mismo_widgets_updated_field_value()      defined in m-widget-fields.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            extract( $widget_field );

            // Use helper function to get updated field values
            $instance[$mismo_widgets_name] = mismo_widgets_updated_field_value( $widget_field, $new_instance[$mismo_widgets_name] );
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses    mismo_widgets_show_widget_field()        defined in m-widget-fields.php
     */
    public function form( $instance ) {

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            // Make array elements available as variables
            extract( $widget_field );

            if ( empty( $instance ) && isset( $mismo_widgets_default ) ) {
                $mismo_widgets_field_value = $mismo_widgets_default;
            } elseif ( empty( $instance ) ) {
                $mismo_widgets_field_value = '';
            } else {
                $mismo_widgets_field_value = wp_kses_post( $instance[$mismo_widgets_name] );
            }
            mismo_widgets_show_widget_field( $this, $widget_field, $mismo_widgets_field_value );
        }
    }

}
