<?php
/**
 * Widget to show the content of List Posts.
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

class Mismo_List_Posts extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        $widget_ops = array( 
            'classname'                     => 'mismo_list_posts',
            'description'                   => __( 'Display posts in one columns with multiple layout.', 'mismo' ),
            'customize_selective_refresh'   => true,
        );
        parent::__construct( 'mismo_list_posts', __( 'Mismo: List Posts', 'mismo' ), $widget_ops );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {

        $fields = array(
            'list_posts_section' => array(
                'mismo_widgets_name'         => 'list_posts_section',
                'mismo_widgets_title'        => __( 'one Column Posts', 'mismo' ),
                'mismo_widgets_field_type'   => 'heading'
            ),

            'list_posts_label' => array(
                'mismo_widgets_name'         => 'list_posts_label',
                'mismo_widgets_title'        => __( 'Widget Title', 'mismo' ),
                'mismo_widgets_field_type'   => 'text'
            ),

            'list_posts_type' => array(
                'mismo_widgets_name'          => 'list_posts_type',
                'mismo_widgets_title'         => __( 'Choose Posts Category', 'mismo' ),
                'mismo_widgets_default'       => 'latest',
                'mismo_widgets_field_type'     => 'select',
                'mismo_widgets_field_options' => array(
                    'latest'    => __( 'Latest Posts', 'mismo' ),
                    'category'    => __( 'Category Posts', 'mismo' )
                ),
                'mismo_widget_field_relation'  => array(
                    'values' => array(
                        'category' => array(
                            'show_fields'   => array(
                                'select-category',
                            ),
                        ),
                        'latest' => array(
                            'hide_fields'   => array(
                                'select-category',
                            ),
                        )
                    )
                ),
            ),

            'list_posts_cat_slug' => array(
                'mismo_widgets_name'         => 'list_posts_cat_slug',
                'mismo_widget_field_wrapper' => 'select-category',
                'mismo_widgets_title'        => __( 'Select Category', 'mismo' ),
                'mismo_widgets_description'  => __( 'Select category from dropdown options', 'mismo' ),
                'mismo_widgets_field_type'   => 'mismo_category_dropdown',
            ),

            'list_posts_layout' => array(
                'mismo_widgets_name'         => 'list_posts_layout',
                'mismo_widgets_title'        => __( 'Select widget layout', 'mismo' ),
                'mismo_widgets_field_type'   => 'selector',
                'mismo_widgets_default'      => 'classic--layout-1',
                'mismo_widgets_field_options' => array(
                    'classic--layout-1'  => array(
                        'label'     => esc_html__( 'Classic Layout 1', 'mismo' ),
                        'img_path'  => get_template_directory_uri() . '/assets/images/classic-list-layout.png'
                    ),
                    'list--layout'  => array(
                        'label'     => esc_html__( 'List Layout', 'mismo' ),
                        'img_path'  => get_template_directory_uri() . '/assets/images/list-layout.png'
                    )
                ),
            ),
        );
        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );
        if ( empty( $instance ) ) {
            return ;
        }

        $list_posts_label       = empty( $instance['list_posts_label'] ) ? '' : $instance['list_posts_label'];
        $list_posts_type        = empty( $instance['list_posts_type'] ) ? '' : $instance['list_posts_type'];
        $list_posts_cat_slug    = empty( $instance['list_posts_cat_slug'] ) ? '' : $instance['list_posts_cat_slug'];
        $list_posts_layout      = empty( $instance['list_posts_layout'] ) ? '' : $instance['list_posts_layout'];

        if ( $list_posts_layout == 'classic--layout-1' ) {
            $post_count = 3;
        } else {
            $post_count = 5;
        }
        echo $before_widget;
?>
            <div class="one-column-posts-wrapper <?php echo 'widget-'.esc_attr( $list_posts_layout ); ?>">
                <?php
                    if ( ! empty( $list_posts_label ) ) {
                        echo wp_kses_post( $before_title ).esc_html( $list_posts_label ).wp_kses_post( $after_title );   
                    }
                    
                    $oc_posts_args = array(
                        'post_type'         => 'post',
                        'posts_per_page'    => absint( $post_count ),
                    );
                    if ( 'category' == $list_posts_type ) {
                        $oc_posts_args['category_name'] = esc_attr( $list_posts_cat_slug );
                    }
                    
                    $oc_posts_query = new WP_Query( $oc_posts_args );
                    $oc_total_posts = $oc_posts_query->post_count;
                    if ( $oc_posts_query -> have_posts() ):
                        echo '<div class="one-column-posts-content">';
                        if ( 'list--layout' == $list_posts_layout ) {
                            $thumb_size     = 'medium';
                            $title_class    = 'small-size';
                            echo '<div class="one-column-list-post-wrap">';
                        }
                        $post_count = 1;
                            while ( $oc_posts_query -> have_posts() ): $oc_posts_query -> the_post();
                                $oc_current_post_num = $oc_posts_query->current_post;
                                
                                if ( 'list--layout' != $list_posts_layout ) {
                                    if ( ( $oc_current_post_num%3 ) == 0 && $post_count == 1 ) {
                                        $title_class = 'medium-size';
                                        echo '<div class="'. esc_attr( $list_posts_layout ) .'-full-contain-post-wrap mt-clearfix">';
                                    } elseif ( $post_count == 2 ) {
                                        $title_class = 'small-size';
                                        echo '<div class="one-column-list-post-wrap mt-clearfix">';
                                    }
                                }

                                /**
                                 * function for post content
                                 */
                                mismo_list_posts_section( $oc_current_post_num, $list_posts_layout, $title_class );

                                if ( 'list--layout' != $list_posts_layout ) {
                                    if ( ( $oc_current_post_num%3 ) == 0 && $post_count == 1 ) {
                                        echo '</div><!-- .'. esc_attr( $list_posts_layout ) .'-full-contain-post-wrap -->';
                                    } elseif ( $post_count == 3 || ( $oc_total_posts - 1 ) == $oc_current_post_num ) {
                                        echo '</div><!-- .one-column-list-post-wrap -->';
                                        $post_count = 0;
                                    }
                                    $post_count++;
                                }

                            endwhile;
                        if ( 'list--layout' == $list_posts_layout ) {
                            echo '</div><!-- .one-column-list-post-wrap -->';
                        }
                        echo '</div><!-- .one-column-posts-content -->';
                    endif;
                    wp_reset_postdata();
                ?>
            </div><!-- .one-column-posts-wrapper -->
<?php
        echo $after_widget;
    }


    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    mismo_widgets_updated_field_value()      defined in m-widget-fields.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            extract( $widget_field );

            // Use helper function to get updated field values
            $instance[$mismo_widgets_name] = mismo_widgets_updated_field_value( $widget_field, $new_instance[$mismo_widgets_name] );
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses    mismo_widgets_show_widget_field()        defined in m-widget-fields.php
     */
    public function form( $instance ) {

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            // Make array elements available as variables
            extract( $widget_field );

            if ( empty( $instance ) && isset( $mismo_widgets_default ) ) {
                $mismo_widgets_field_value = $mismo_widgets_default;
            } elseif ( empty( $instance ) ) {
                $mismo_widgets_field_value = '';
            } else {
                $mismo_widgets_field_value = wp_kses_post( $instance[$mismo_widgets_name] );
            }
            mismo_widgets_show_widget_field( $this, $widget_field, $mismo_widgets_field_value );
        }
    }

}
