<?php
/**
 * Mismo: Social Media
 *
 * Widget show the social media icons.
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

class Mismo_Social_Media extends WP_widget {

	/**
     * Register widget with WordPress.
     */
    public function __construct() {
        $widget_ops = array( 
            'classname'         => 'mismo_social_media',
            'description'       => __( 'A widget shows the social media icons.', 'mismo' ),
            'customize_selective_refresh'   => true,
        );
        parent::__construct( 'mismo_social_media', __( 'Mismo: Social Media', 'mismo' ), $widget_ops );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {
        
        $fields = array(

            'widget_title' => array(
                'mismo_widgets_name'         => 'widget_title',
                'mismo_widgets_title'        => __( 'Widget title', 'mismo' ),
                'mismo_widgets_field_type'   => 'text'
            )
        );
        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );

        if ( empty( $instance ) ) {
            return ;
        }

        $mismo_widget_title  = empty( $instance['widget_title'] ) ? '' : $instance['widget_title'];

        echo $before_widget;
    ?>
            <div class="m-widget-social-wrapper">
                <?php
                    if ( ! empty( $mismo_widget_title ) ) {
                        echo $before_title . esc_html( $mismo_widget_title ) . $after_title;
                    }
                    mismo_social_icons();
                ?>
            </div><!-- .m-widget-social-wrapper -->
    <?php
        echo $after_widget;
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    mismo_widgets_updated_field_value()     defined in m-widget-fields.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            extract( $widget_field );

            // Use helper function to get updated field values
            $instance[$mismo_widgets_name] = mismo_widgets_updated_field_value( $widget_field, $new_instance[$mismo_widgets_name] );
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses    mismo_widgets_show_widget_field()       defined in m-widget-fields.php
     */
    public function form( $instance ) {
        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            // Make array elements available as variables
            extract( $widget_field );
            $mismo_widgets_field_value = ! empty( $instance[$mismo_widgets_name] ) ? wp_kses_post( $instance[$mismo_widgets_name] ) : '';
            mismo_widgets_show_widget_field( $this, $widget_field, $mismo_widgets_field_value );
        }
    }
}