<?php
/**
 * Widget to show Timeline
 *
 * @package Mismo
 * 
 * @since 1.0.2
 */

class Mismo_Timeline_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        $widget_ops = array( 
            'classname'                     => 'mismo_timeline_widget',
            'description'                   => __( 'Displays the post Timeline', 'mismo' ),
            'customize_selective_refresh'   => true,
        );
        parent::__construct( 'mismo_timeline_widget', __( 'Mismo: Timeline', 'mismo' ), $widget_ops );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {

        $fields = array(
            'mismo_timeline_section' => array(
                'mismo_widgets_name'         => 'mismo_timeline_section',
                'mismo_widgets_title'        => __( 'Timeline Widget', 'mismo' ),
                'mismo_widgets_field_type'   => 'heading'
            ),

            'mismo_timeline_label' => array(
                'mismo_widgets_name'         => 'mismo_timeline_label',
                'mismo_widgets_title'        => __( 'Widget Title', 'mismo' ),
                'mismo_widgets_field_type'   => 'text'
            ),

            'mismo_timeline_post_type' => array(
                'mismo_widgets_name'          => 'mismo_timeline_post_type',
                'mismo_widgets_title'         => __( 'Choose Posts Category', 'mismo' ),
                'mismo_widgets_default'       => 'latest',
                'mismo_widgets_field_type'     => 'select',
                'mismo_widgets_field_options' => array(
                    'latest'    => __( 'Latest Posts', 'mismo' ),
                    'category'    => __( 'Category Posts', 'mismo' )
                ),
                'mismo_widget_field_relation'  => array(
                    'values' => array(
                        'category' => array(
                            'show_fields'   => array(
                                'select-category',
                            ),
                        ),
                        'latest' => array(
                            'hide_fields'   => array(
                                'select-category',
                            ),
                        )
                    )
                ),
            ),

            'mismo_timeline_cat_slug' => array(
                'mismo_widgets_name'         => 'mismo_timeline_cat_slug',
                'mismo_widget_field_wrapper' => 'select-category',
                'mismo_widgets_title'        => __( 'Select Category', 'mismo' ),
                'mismo_widgets_description'  => __( 'Select category from dropdown options', 'mismo' ),
                'mismo_widgets_field_type'   => 'mismo_category_dropdown',
            ),
            'mismo_post_orderby' => array(
                'mismo_widgets_name'         => 'mismo_post_orderby',
                'mismo_widgets_title'        => esc_html__( 'Order', 'mismo' ),
                'mismo_widgets_default'      => 'rand',
                'mismo_widgets_field_type'   => 'select',
                'mismo_widgets_field_options' => array(
                    'rand'    => __( 'Random', 'mismo' ),
                    'date'    => __( 'Latest', 'mismo' )
                ),
            ),
        );
        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );

        if ( empty( $instance ) ) {
            return ;
        }

        $mismo_timeline_label       = empty( $instance['mismo_timeline_label'] ) ? '' : $instance['mismo_timeline_label'];
        $mismo_timeline_post_type   = empty( $instance['mismo_timeline_post_type'] ) ? '' : $instance['mismo_timeline_post_type'];
        $mismo_timeline_cat_slug    = empty( $instance['mismo_timeline_cat_slug'] ) ? '' : $instance['mismo_timeline_cat_slug'];
        $mismo_post_orderby         = empty( $instance['mismo_post_orderby'] ) ? '' : $instance['mismo_post_orderby'];        

        echo $before_widget;
?>
            <div class="timeline-widget-wrapper">
                <?php
                    if ( ! empty( $mismo_timeline_label ) ) {
                        echo wp_kses_post( $before_title ).esc_html( $mismo_timeline_label ).wp_kses_post( $after_title );   
                    }
                    $oc_posts_args = array(
                        'post_type' => 'post',
                        'posts_per_page' => 5,
                        'orderby' => esc_attr( $mismo_post_orderby ),
                    );
                    if ( 'category' == $mismo_timeline_post_type ) {
                        $oc_posts_args['category_name'] = esc_attr( $mismo_timeline_cat_slug );
                    }

                    $oc_posts_query = new WP_Query( $oc_posts_args );
                    $oc_total_posts = $oc_posts_query->post_count;
                    if ( $oc_posts_query -> have_posts() ):
                            echo '<div class="timeline-widget-wrap">';

                        	$post_count=1;
                            while ( $oc_posts_query -> have_posts() ): $oc_posts_query -> the_post();
                                $oc_current_post_num = $oc_posts_query->current_post;
                                if ( $post_count < 10 ) {
                                    $post_count_refined = '0'.$post_count;
                                } else {
                                    $post_count_refined = $post_count;
                                }

                ?>
                                <article id="post-<?php the_ID(); ?>" class="mt-clearfix">
                                    <?php
                                    echo '<div class="post-content mt-clearfix">';
                                        echo'<div class="trending_number"> <span>'. esc_html( $post_count_refined ).'</span></div>';
                                        echo'<div class="timeline-cat-title-wrap">';
                                            mismo_post_categories_list();
                                            the_title( '<h3 class="post-title"><a href="'. esc_url( get_permalink() ) .'">', '</a></h3>' );
                                            //mismo_posted_on();
                                         echo'</div> <!-- ."cat-title-date-wrap -->';

                                    echo '</div><!-- .post-content -->'; ?>
                                </article>
                <?php
                                $post_count++;
                            endwhile;
                            echo '</div><!-- .timeline-widget-wrap -->';
                    endif;
                    wp_reset_postdata();
                ?>
            </div><!-- .timeline-widget-wrapper -->
<?php
        echo $after_widget;
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    mismo_widgets_updated_field_value()      defined in m-widget-fields.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            extract( $widget_field );

            // Use helper function to get updated field values
            $instance[$mismo_widgets_name] = mismo_widgets_updated_field_value( $widget_field, $new_instance[$mismo_widgets_name] );
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses    mismo_widgets_show_widget_field()        defined in m-widget-fields.php
     */
    public function form( $instance ) {

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            // Make array elements available as variables
            extract( $widget_field );

            if ( empty( $instance ) && isset( $mismo_widgets_default ) ) {
                $mismo_widgets_field_value = $mismo_widgets_default;
            } elseif ( empty( $instance ) ) {
                $mismo_widgets_field_value = '';
            } else {
                $mismo_widgets_field_value = wp_kses_post( $instance[$mismo_widgets_name] );
            }
            mismo_widgets_show_widget_field( $this, $widget_field, $mismo_widgets_field_value );
        }
    }
}