<?php
/**
 * Define custom fields for widgets
 * 
 * @package Mismo
 * 
 * @since 1.0.0
 */

function mismo_widgets_show_widget_field( $instance = '', $widget_field = '', $mismo_widget_field_value = '' ) {

    extract( $widget_field );
    
    $mismo_widget_field_wrapper  = isset( $mismo_widget_field_wrapper ) ? $mismo_widget_field_wrapper : '';
    $mismo_widget_field_relation = isset( $mismo_widget_field_relation ) ? $mismo_widget_field_relation : array();
    $mismo_widget_relation_json  = wp_json_encode( $mismo_widget_field_relation );
    $mismo_widget_relation_class = ( $mismo_widget_field_relation ) ? 'mismo_widget_field_relation' : '';

	switch ( $mismo_widgets_field_type ) {

        // heading
        case 'heading':
        ?>
            <h4 class="field-heading"><span class="field-label"><strong><?php echo esc_html( $mismo_widgets_title ); ?></strong></span></h4>
            <p>
                <?php if ( isset( $mismo_widgets_description ) ) { ?>
                    <small><em><?php echo esc_html( $mismo_widgets_description ); ?></em></small>
                <?php } ?>
            </p>
        <?php
        break;

		// text field
		case 'text':
		?>
			<p class="mt-widget-field-wrapper <?php echo esc_attr( $mismo_widget_field_wrapper ); ?>">
                <label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>"><?php echo esc_html( $mismo_widgets_title ); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>" name="<?php echo esc_attr( $instance->get_field_name( $mismo_widgets_name ) ); ?>" type="text" value="<?php echo esc_html( $mismo_widget_field_value ); ?>" />
                <?php if ( isset( $mismo_widgets_description ) ) { ?>
                    <br />
                    <small><em><?php echo esc_html( $mismo_widgets_description ); ?></em></small>
                <?php } ?>
            </p>
		<?php
		break;

        /**
         * checkbox
         */
        case 'checkbox' :
        ?>
            <p class="mt-widget-field-wrapper <?php echo esc_attr( $mismo_widget_field_wrapper ); ?>">
                <input id="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>" name="<?php echo esc_attr( $instance->get_field_name( $mismo_widgets_name ) ); ?>" type="checkbox" value="1" <?php checked( '1', $mismo_widget_field_value ); ?> class="widefat <?php echo esc_attr( $mismo_widget_relation_class ); ?>" data-relations="<?php echo esc_attr( $mismo_widget_relation_json ) ?>"/>
                <label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>"><?php echo esc_html( $mismo_widgets_title ); ?></label>

                <?php if ( isset( $mismo_widgets_description ) ) { ?>
                    <br />
                    <em><?php echo wp_kses_post( $mismo_widgets_description ); ?></em>
                <?php } ?>
            </p>
        <?php
            break;

         /**
         * select field
         */
        case 'select' :
        ?>
            <p class="mt-widget-field-wrapper <?php echo esc_attr( $mismo_widget_field_wrapper ); ?>">
               <label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>"><?php echo esc_html( $mismo_widgets_title ); ?>:</label>
                <?php if ( isset( $mismo_widgets_description ) ) { ?>
                    <br />
                    <em><?php echo wp_kses_post( $mismo_widgets_description ); ?></em>
                <?php } ?>
                <select name="<?php echo esc_attr( $instance->get_field_name( $mismo_widgets_name ) ); ?>" id="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>" class="widefat <?php echo esc_attr( $mismo_widget_relation_class ); ?>" data-relations="<?php echo esc_attr( $mismo_widget_relation_json ) ?>">
                    <?php foreach ( $mismo_widgets_field_options as $select_option_name => $select_option_title ) { ?>
                        <option value="<?php echo esc_attr( $select_option_name ); ?>" id="<?php echo esc_attr( $instance->get_field_id( $select_option_name ) ); ?>" <?php selected( $select_option_name, $mismo_widget_field_value ); ?>><?php echo esc_html( $select_option_title ); ?></option>
                    <?php } ?>
                </select>
            </p>            
        <?php 
            break;

        /**
         * upload widget field
         */
        case 'upload':
            $image = $image_class = "";
            if ( $mismo_widget_field_value ) { 
                $image = '<img src="'.esc_url( $mismo_widget_field_value ).'" style="max-width:100%;"/>';    
                $image_class = ' hidden';
            }
            ?>
            <div class="attachment-media-view">

            <p><span class="field-label"><label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>"><?php echo esc_html( $mismo_widgets_title ); ?>:</label></span></p>
            
                <div class="placeholder<?php echo esc_attr( $image_class ); ?>">
                    <?php esc_html_e( 'No image selected', 'mismo' ); ?>
                </div>
                <div class="thumbnail thumbnail-image">
                    <?php echo $image; ?>
                </div>

                <div class="actions mt-clearfix">
                    <button type="button" class="button mt-delete-button align-left"><?php esc_html_e( 'Remove', 'mismo' ); ?></button>
                    <button type="button" class="button mt-upload-button alignright"><?php esc_html_e( 'Select Image', 'mismo' ); ?></button>
                    
                    <input name="<?php echo esc_attr( $instance->get_field_name( $mismo_widgets_name ) ); ?>" id="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>" class="upload-id" type="hidden" value="<?php echo esc_url( $mismo_widget_field_value ); ?>"/>
                </div>

            <?php if ( isset( $mismo_widgets_description ) ) { ?>
                <br />
                <em><?php echo wp_kses_post( $mismo_widgets_description ); ?></em>
            <?php } ?>

            </div>
            <?php
            break;    

        /**
         * url widget field
         */
        case 'url' :
        ?>
            <p>
                <span class="field-label"><label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>"><?php echo esc_html( $mismo_widgets_title ); ?></label></span>
                <input class="widefat" id="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>" name="<?php echo esc_attr( $instance->get_field_name( $mismo_widgets_name ) ); ?>" type="text" value="<?php echo esc_url( $mismo_widget_field_value ); ?>" />

                <?php if ( isset( $mismo_widgets_description ) ) { ?>
                    <br />
                    <em><?php echo wp_kses_post( $mismo_widgets_description ); ?></em>
                <?php } ?>
            </p>
        <?php
            break;    

		case 'mismo_category_dropdown':
			$select_field = 'name="'. esc_attr( $instance->get_field_name( $mismo_widgets_name ) ) .'" id="'. esc_attr( $instance->get_field_id( $mismo_widgets_name ) ) .'" class="widefat"';
    	?>
    		<p class="post-cat mt-widget-field-wrapper <?php echo esc_attr( $mismo_widget_field_wrapper ); ?>">
    			<label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>" >
    				<?php echo esc_html( $mismo_widgets_title ); ?>:
    			</label><br/>
                <?php  if ( isset( $mismo_widgets_description ) ) { ?>
                        <small><em><?php echo esc_html( $mismo_widgets_description ); ?></em></small>
                <?php 
                } 	
                    $categories_args = wp_parse_args( array(
                        'taxonomy'          => 'category',
                        'show_option_none'  => __( '- - Select Category - -', 'mismo' ),
                        'selected'          => esc_attr( $mismo_widget_field_value ),
                        'show_option_all'   => '',
                        'orderby'           => 'id',
                        'order'             => 'ASC',
                        'show_count'        => 0,
                        'hide_empty'        => 1,
                        'child_of'          => 0,
                        'exclude'           => '',
                        'hierarchical'      => 1,
                        'depth'             => 0,
                        'tab_index'         => 0,
                        'hide_if_empty'     => false,
                        'option_none_value' => 0,
                        'value_field'       => 'slug',
                    ) ); 

    			 	$categories_args['echo'] = false;

                    $dropdown = wp_dropdown_categories( $categories_args );
                    $dropdown = str_replace( '<select', '<select ' . $select_field, $dropdown );
                    echo $dropdown;
                ?>
    		</p>

		<?php 
			break;

        // number
        case 'number' :
            if ( empty( $mismo_widget_field_value ) ) {
                $mismo_widget_field_value = $mismo_widgets_default;
            }
        ?>
            <p>
                <label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>"><?php echo esc_html( $mismo_widgets_title ); ?>:</label>
                    <input name="<?php echo esc_attr( $instance->get_field_name( $mismo_widgets_name ) ); ?>" type="number" step="1" min="1" <?php if ( ! empty( $mismo_widget_number_limit ) ) { echo 'max='.absint( $mismo_widget_number_limit ); } ?> id="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>" value="<?php echo absint( $mismo_widget_field_value ); ?>" class="small-text" />

                <?php if ( isset( $mismo_widgets_description ) ) { ?>
                    <br />
                    <small><?php echo esc_html( $mismo_widgets_description ); ?></small>
                <?php } ?>
            </p>
        <?php
            break;

        /**
         * Radio fields
        */    
        case 'radio' :
            if ( empty( $mismo_widget_field_value ) ) {
                $mismo_widget_field_value = $mismo_widgets_default;
            }
        ?>
            <p>
                <label for="<?php echo esc_attr( $instance->get_field_id( $mismo_widgets_name ) ); ?>"><?php echo esc_html( $mismo_widgets_title ); ?>:</label><br/>
                <?php if ( isset( $mismo_widgets_description ) ) { ?>
                    <small><?php echo esc_html( $mismo_widgets_description ); ?></small>
                <?php } ?>
                <div id="mt-radio" class="radio-wrapper">
                    <?php
                        foreach ( $mismo_widgets_field_options as $mismo_option_name => $mismo_option_title ) {
                    ?>
                        <input id="<?php echo esc_attr( $instance->get_field_id( $mismo_option_name ) ); ?>" class="<?php echo esc_attr( $mismo_widgets_class ); ?>" name="<?php echo esc_attr( $instance->get_field_name( $mismo_widgets_name ) ); ?>" type="radio" value="<?php echo esc_html( $mismo_option_name ); ?>" <?php checked( $mismo_option_name, $mismo_widget_field_value ); ?> />
                        <label for="<?php echo esc_attr( $instance->get_field_id( $mismo_option_name ) ); ?>"><?php echo esc_html( $mismo_option_title ); ?></label>
                    <?php } ?>
                </div>
            </p>
        <?php
            break;
        
        /**
         * selector widget field
         */
        case 'selector':
            if ( empty( $mismo_widget_field_value ) ) {
                $mismo_widget_field_value = $mismo_widgets_default;
            }
        ?>
            <p><span class="field-label"><label class="field-title"><?php echo esc_html( $mismo_widgets_title ); ?></label></span></p>
        <?php            
            echo '<div class="selector-labels">';
            foreach ( $mismo_widgets_field_options as $key => $value ) {
                $img_path = $value['img_path'];
                $class = ( $mismo_widget_field_value == $key ) ? 'selector-selected': '';
                echo '<label class="'. esc_attr( $class ) .'" data-val="'. esc_attr( $key ) .'">';
                echo '<img src="'. esc_url( $value['img_path'] ) .'" title="'. esc_attr( $value['label'] ) .'" alt="'. esc_attr( $value['label'] ) .'"/>';
                echo '</label>';
            }
            echo '</div>';
            echo '<input data-default="'. esc_attr( $mismo_widget_field_value ) .'" type="hidden" value="'. esc_attr( $mismo_widget_field_value ) .'" name="'. esc_attr( $instance->get_field_name( $mismo_widgets_name ) ) .'"/>';
            break;
	}
}

function mismo_widgets_updated_field_value( $widget_field, $new_field_value ) {

    extract( $widget_field );

    if ( $mismo_widgets_field_type == 'number') {
        return absint( $new_field_value );
    } elseif ( $mismo_widgets_field_type == 'textarea' ) {
        return wp_kses_post( $new_field_value );
    } elseif ( $mismo_widgets_field_type == 'url' ) {
        return esc_url_raw( $new_field_value );
    } else {
        return sanitize_text_field( $new_field_value );
    }
}