<?php
/**
 * Functions for handling the theme custom widgets.
 * 
 * @package Mismo
 * 
 * @since 1.0.0 
 */


 /**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
 
function mismo_widgets_init() {
    /**
     * Register default sidebar.  
     */    
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'mismo' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="custom-title"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
    ) );

	/**
     * Register Header Sticky Sidebar.  
     */    
	register_sidebar( array(
		'name'          => esc_html__( 'Header Sticky Sidebar', 'mismo' ),
		'id'            => 'header-sticky-sidebar',
		'description'   => esc_html__( 'Add Image widget here for advertisement banner.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="custom-title"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );
	
    /**
     * Register Header Ads area.
     */    
	register_sidebar( array(
		'name'          => esc_html__( 'Header Ads Area', 'mismo' ),
		'id'            => 'header-ads-area',
		'description'   => esc_html__( 'Add Image widget here for advertisement banner.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="custom-title"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
    ) );

    /**
     * Register Front Banner Section.
     */    
	register_sidebar( array(
		'name'          => esc_html__( 'Front Banner Section', 'mismo' ),
		'id'            => 'front-banner-section',
		'description'   => esc_html__( 'Add M: Banner widget here.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="custom-title"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );


	/**
     * Register Front Main content Section.
     */    
	register_sidebar( array(
		'name'          => esc_html__( 'Front Main Content Section', 'mismo' ),
		'id'            => 'front-main-content-section',
		'description'   => esc_html__( 'Add M: List Posts, M: Grid Posts, M: Carousel Grid Posts widgets here.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="custom-title"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );

	/**
     * Register Front Main content Aside Sidebar.
     */    
	register_sidebar( array(
		'name'          => esc_html__( 'Front Main Content Aside', 'mismo' ),
		'id'            => 'front-main-content-aside',
		'description'   => esc_html__( 'Add M: Default Tabbed, M: List Posts Widget,  Widget here.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="custom-title"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );
	
	/**
     * Register Front Full Width Section.
     */    
	register_sidebar( array(
		'name'          => esc_html__( 'Front FullWidth Section', 'mismo' ),
		'id'            => 'front-full-width-section',
		'description'   => esc_html__( 'Add M: Grid Posts, M: Carousel Grid Posts Widget here.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="custom-title"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );
	
	/**
     * Register Footer Sidebar Section.
     */
	register_sidebars( 4, array(
		'name'          => esc_html__( 'Footer %d', 'mismo' ),
		'id'            => 'footer',
		'description'   => esc_html__( 'Add widgets here.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	/**
     * Register Bottom Footer Sidebar Section.
     */
	register_sidebars( 3, array(
		'name'          => esc_html__( 'Bottom Footer %d', 'mismo' ),
		'id'            => 'bottom-footer',
		'description'   => esc_html__( 'Add widgets here.', 'mismo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

    /**
     * Register custom widgets
     */
	register_widget( 'Mismo_Banner' );
	register_widget( 'Mismo_Grid_Posts' );
	register_widget( 'Mismo_List_Posts' );
	register_widget( 'Mismo_Carousel_Grid_Posts' );
	register_widget( 'Mismo_Default_Tabbed' );
	register_widget( 'Mismo_Social_Media' );
	register_widget( 'Mismo_Timeline_Widget' );
	
}
add_action( 'widgets_init', 'mismo_widgets_init' );

// Load widgets files
require get_template_directory().'/inc/widgets/m-widgets-fields.php';
require get_template_directory().'/inc/widgets/m-widgets-hooks.php';
require get_template_directory().'/inc/widgets/m-banner-widget.php';
require get_template_directory().'/inc/widgets/m-grid-posts-widget.php';
require get_template_directory().'/inc/widgets/m-list-posts-widget.php';
require get_template_directory().'/inc/widgets/m-carousel-grid-posts-widget.php';
require get_template_directory().'/inc/widgets/m-default-tabbed-widget.php';
require get_template_directory().'/inc/widgets/m-social-media-widget.php';
require get_template_directory().'/inc/widgets/m-timeline-widget.php';
