<?php
/**
 * Hooks for Theme custom widgets content.
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

if ( ! function_exists( 'mismo_banner_top_stories' ) ) :

    /**
     * M: Banner Top Stories Section 
     */
    function mismo_banner_top_stories( $top_stories_label ) {

        $top_stories_query = new WP_Query( array ( 
                'post_type' => 'post',
                'posts_per_page' => 4
            ) );
        if ( ! ( $top_stories_query -> have_posts() ) ) {
            return;
        }
    ?>
            <div class="m-banner-top-stories">
            <?php
                if ( ! empty( $top_stories_label ) ) {
                    echo '<div class="top-stories-section-title">'.esc_html( $top_stories_label ).'</div>';
                }
                while ( $top_stories_query -> have_posts() ): $top_stories_query -> the_post();
                $post_id = get_the_ID();
                if ( has_post_thumbnail() ) {
                    $top_story_post_class = ' has-thumbnail';
                } else {
                    $top_story_post_class = ' no-thumbnail';
                }
                    echo '<div class="top-stories-post-wrapper wow fadeInLeft'.esc_attr( $top_story_post_class ).'">';
                        mismo_post_categories_list();
                        echo '<div class="top-stories-post">';
                            if ( has_post_thumbnail() ) {
                                $thumbnail_url = get_the_post_thumbnail_url();
                    ?>
                                <div class="top-stories-image">
                                    <a href="<?php the_permalink(); ?>">
                                        <figure class="post-thumb mismo-bg-img small-image" style="background-image: url(<?php echo esc_url( $thumbnail_url ); ?>);">
                                        </figure>
                                    </a>
                                </div><!-- top stories image -->
                    <?php
                            }
                            the_title( '<h3 class="post-title small-size"><a href="'. esc_url( get_permalink() ).'">', '</a></h3>' );
                        echo '</div><!-- .top-stories-post -->';
                        mismo_post_time();
                    echo '</div><!-- .top-stories-post-wrapper -->';
                endwhile;
                wp_reset_postdata();
            ?>
            </div><!-- .m-banner-top-stories -->
<?php        
    }

endif;

/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_banner_slider' ) ) :

    /**
     * M: Banner Slider Section 
     */
    function mismo_banner_slider( $slider_section_cat_slug ) {
?>
        <div class="banner-slider-wrap">
            <div class="m-banner-slider cS-hidden">
                <?php
                    $slider_cat_args = array (
                        'post_type'         => 'post',
                        'category_name'     => esc_html( $slider_section_cat_slug ),
                        'posts_per_page'    => 3
                    );
                    $slider_cat_query = new WP_Query( $slider_cat_args );
                    while ( $slider_cat_query -> have_posts() ): $slider_cat_query -> the_post();
                        get_template_part( 'template-parts/widgets-layouts/m-banner/content', 'slider' );
                    endwhile;
                    wp_reset_postdata();
                ?>
            </div><!-- .m-banner-slider -->
        </div><!-- .banner-slider-wrap -->
<?php   
    }

endif;

/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_banner_featured_section' ) ) :

    /**
     * M: Banner Featured Section 
     */
    function mismo_banner_featured_section( $featured_section_label, $featured_section_cat_slug, $featured_section_post_order ) {
        if ( empty( $featured_section_cat_slug ) ) {
            return;
        }
?>
        <div class="m-banner-featured-section">
            <?php
                if ( ! empty( $featured_section_label ) ) {
                    echo '<div class="featured-section-section-title">'.esc_html( $featured_section_label ).'</div>';
                }
                $slider_cat_args = array (
                    'post_type'         => 'post',
                    'category_name'     => esc_html( $featured_section_cat_slug ),
                    'posts_per_page'    => 3
                );
                if ( 'random-order' == $featured_section_post_order ) {
                    $slider_cat_args[ 'orderby' ] = 'rand';
                }
                $slider_cat_query = new WP_Query( $slider_cat_args );
                while ( $slider_cat_query -> have_posts() ): $slider_cat_query -> the_post();
                    get_template_part( 'template-parts/widgets-layouts/m-banner/content', 'featured' );
                endwhile;
                wp_reset_postdata();
            ?>
        </div><!-- .m-banner-featured-section -->
<?php   
    }

endif;

/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_grid_posts_section' ) )  :

    /**
     * M: Two Column Posts Section
     */
    function mismo_grid_posts_section( $title_class ) {
        if ( has_post_thumbnail() ) {
            $thumb_class = 'wow fadeInUp has-thumbnail mt-clearfix';
        } else {
            $thumb_class = 'wow fadeInUp no-thumbnail mt-clearfix';
        }
?>
        
        <article id="post-<?php the_ID(); ?>" <?php post_class( $thumb_class ); ?>>
        <?php
            if ( has_post_thumbnail() ) {
                $thumbnail_url = get_the_post_thumbnail_url();
        ?>
                <div class="post-thumb">
                    <a href="<?php the_permalink(); ?>">
                        <figure class="mismo-bg-img" style="background-image:url(<?php echo esc_url( $thumbnail_url ); ?>);">
                        </figure>
                    </a>
                </div><!-- .post-thumb -->
        <?php
            }
            echo '<div class="post-content">';
                mismo_post_categories_list();
                the_title( '<h3 class="post-title '.esc_html( $title_class ).'"><a href="'. esc_url( get_permalink() ).'">', '</a></h3>' );
                mismo_posted_on();
                mismo_posted_by();                    
        ?>
                <div class="entry-content">
                    <?php the_excerpt(); ?>
                </div> <!-- .entry-content -->
            </div><!-- .post-content -->
        </article>
<?php   
    }

endif;

/*-----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'mismo_list_posts_section' ) ) :

    /**
     * M: One Column Posts Section
     */
    function mismo_list_posts_section( $oc_current_post_num, $mismo_list_posts_layout, $title_class ) {
        if ( has_post_thumbnail() ) {
            $thumb_class = 'wow fadeInUp has-thumbnail mt-clearfix';
        } else {
            $thumb_class = 'wow fadeInUp no-thumbnail mt-clearfix';
        }
?>
        <article id="post-<?php the_ID(); ?>" <?php post_class( $thumb_class ); ?>>
        <?php
            if ( has_post_thumbnail() ) {
                $thumbnail_url = get_the_post_thumbnail_url();
        ?>
                <div class="post-thumb">
                    <a href="<?php the_permalink(); ?>">
                        <figure class="mismo-bg-img" style="background-image:url(<?php echo esc_url( $thumbnail_url ); ?>);">
                        </figure>
                    </a>
                </div><!-- .post-thumb -->
        <?php
            }
            echo '<div class="post-content">';
                mismo_post_categories_list();
                the_title( '<h3 class="post-title '.esc_html( $title_class ).'"><a href="'. esc_url( get_permalink() ).'">', '</a></h3>' );
                mismo_posted_on();
                if ( $oc_current_post_num == 0 && $mismo_list_posts_layout == 'classic--layout-1' ) {
                    the_excerpt();
                }
            echo '</div><!-- .post-content -->';
        ?>
        </article>
<?php
    }

endif;
