<?php
/**
 * The Sidebar containing the bottom footer widget areas.
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

 /**
 * Checks bottom footer sidebars active or not.
 * returns empty if none of bottom footer sidebar is active
 * 
 */

$mismo_bottom_footer_widget_option = get_theme_mod( 'mismo_bottom_footer_widget_option', true );
if ( false === $mismo_bottom_footer_widget_option ) {
    return;
}
 
if ( !is_active_sidebar( 'bottom-footer' ) && !is_active_sidebar( 'bottom-footer-2' ) && !is_active_sidebar( 'bottom-footer-3' ) && !is_active_sidebar( 'bottom-footer-4' ) ) {
	return;
}
$mismo_bottom_footer_widget_layout = get_theme_mod( 'mismo_bottom_footer_widget_layout', 'three-column' );
?>
<div id="bottom-footer-widget-sec" class="bottom-footer-widgets-wrapper bottom_footer_<?php echo esc_attr( $mismo_bottom_footer_widget_layout ); ?>">
    <div class="mt-container">
        <div class="bottom-footer-widgets-area">
            <div class="m-bottom-footer-widget-wrapper m-column-wrapper">
                <?php
                if ( is_active_sidebar( 'bottom-footer' ) ) :
                    echo '<div class="m-bottom-footer-widget wow fadeInLeft" data-wow-duration="0.5s">';
                        dynamic_sidebar( 'bottom-footer' );
                    echo '</div>';
                endif;
                
                if ( $mismo_bottom_footer_widget_layout != 'one-column' ) {
                    if ( is_active_sidebar( 'bottom-footer-2' ) ) :
                        echo '<div class="m-bottom-footer-widget wow fadeInLeft" data-wow-duration="0.5s">';
                            dynamic_sidebar( 'bottom-footer-2' );
                        echo '</div>';
                    endif;
                }
                
                if ( $mismo_bottom_footer_widget_layout == 'three-column' ) {
                    if ( is_active_sidebar( 'bottom-footer-3' ) ) :
                        echo '<div class="m-bottom-footer-widget wow fadeInLeft" data-wow-duration="0.5s">';
                            dynamic_sidebar( 'bottom-footer-3' );
                        echo '</div>';
                    endif;
                }
                ?>
            </div><!-- .m-bottom-footer-widget-wrapper -->
        </div><!-- .bottom-footer-widgets-area -->
    </div><!-- mt-container -->
</div><!-- .bottom-footer-widgets-wrapper -->