<?php
/**
 * The Sidebar containing the footer widget areas.
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

/**
 * Checks footer sidebars active or not.
 * returns empty if none of footer sidebar is active
 * 
 */
$mismo_footer_widget_option = get_theme_mod( 'mismo_footer_widget_option', true );
if ( false === $mismo_footer_widget_option ) {
    return;
}
 
if ( !is_active_sidebar( 'footer' ) && !is_active_sidebar( 'footer-2' ) && !is_active_sidebar( 'footer-3' ) && !is_active_sidebar( 'footer-4' ) ) {
	   return;
}
$mismo_footer_widget_layout = get_theme_mod( 'mismo_footer_widget_layout', 'four-column' );
?>
<div id="footer-widget-sec" class="footer-widgets-wrapper footer_<?php echo esc_attr( $mismo_footer_widget_layout ); ?>">
    <div class="mt-container">
        <div class="footer-widgets-area">
            <div class="m-footer-widget-wrapper m-column-wrapper">
            <?php
                if ( is_active_sidebar( 'footer' ) ) :
                    echo '<div class="m-footer-widget wow fadeInLeft" data-wow-duration="0.2s">';
                        dynamic_sidebar( 'footer' );
                    echo '</div>';
                endif;

                if ( $mismo_footer_widget_layout != 'one-column' ) {
                    if ( is_active_sidebar( 'footer-2' ) ) :
                        echo '<div class="m-footer-widget wow fadeInLeft" data-wow-duration="0.4s">';
                            dynamic_sidebar( 'footer-2' );
                        echo '</div>';
                    endif;
                } 
                
                if ( $mismo_footer_widget_layout == 'three-column' || $mismo_footer_widget_layout == 'four-column' ) { 
                    if ( is_active_sidebar( 'footer-3' ) ) :
                        echo '<div class="m-footer-widget wow fadeInLeft" data-wow-duration="0.6s">';
                            dynamic_sidebar( 'footer-3' );
                        echo '</div>';
                    endif;
                }
                
                if ( $mismo_footer_widget_layout == 'four-column' ) {
                    if ( is_active_sidebar( 'footer-4' ) ) :
                        echo '<div class="m-footer-widget wow fadeInLeft" data-wow-duration="0.8s">';
                            dynamic_sidebar( 'footer-4' );
                        echo '</div>';
                    endif;
                } ?>
            </div><!-- .m-footer-widget-wrapper -->
        </div><!-- .footer-widgets-area -->
    </div><!-- .mt-container -->
</div><!-- .footer-widgets-wrapper -->