<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Mismo
 */ 
get_header();
wp_reset_postdata();
?>
<div class="single-post-content-wrapper mt-clearfix">
	<div id="primary" class="content-area">
		<main id="main" class="site-main">

		<?php
		while ( have_posts() ) :
			the_post();

			get_template_part( 'template-parts/content-single', get_post_format() );

			the_post_navigation();

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		/**
		 * hook - mismo_after_single_page
		 * 
		 * @hooked - mismo_related_posts_section - 10
		 */
		do_action( 'mismo_after_single_page' );
		?>
		</main><!-- #main -->
	</div><!-- #primary -->

	<?php get_sidebar(); ?>
</div><!-- .single-post-content-wrapper -->
<?php
	/**
	* hook - mismo_after_recent_missed
	* 
	* @hooked - mismo_you_may_have_missed_section - 10
	*/
	do_action( 'mismo_after_recent_missed' );

	get_footer();
