<?php
/**
 * Displays Author bio on single post
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

$author_id         = get_the_author_meta( 'ID' );
$author_avatar     = get_avatar( $author_id, 'thumbnail' );
$author_post_link  = get_the_author_posts_link();
$author_bio        = get_the_author_meta( 'description' );
$author_url        = get_the_author_meta( 'user_url' );

?>

<div class="m-author-box" itemprop="author" itemscope="itemscope" itemtype="http://schema.org/Person">

	<?php if ( $author_avatar ) { ?>
		<div itemprop="avatar" class="m-author__avatar">
			<?php echo wp_kses_post( $author_avatar ); ?>
		</div><!-- .m-author-avatar -->
	<?php } ?>

	<div class="m-author-info">
		<?php if ( $author_post_link ) { ?>
				<h5 itemprop="name" class="m-author-name"><?php echo wp_kses_post( $author_post_link ); ?></h5>
		<?php } ?>

		<?php if ( $author_bio ) { ?>
			<div itemprop="description" class="m-author-bio">
				<?php echo wp_kses_post( $author_bio ); ?>
			</div><!-- .m-author-bio -->
		<?php } ?>

		<div class="m-author-meta">
			<?php if ( $author_url ) { ?>
				<div itemprop="url" class="m-author-website">
					<span><?php esc_html_e( 'Website', 'mismo' ); ?></span>
					<a href="<?php echo esc_url( $author_url ); ?>" target="_blank"><?php echo esc_url( $author_url ); ?></a>
				</div><!-- .m-author-website -->
			<?php } ?>
		</div><!-- .m-author-meta -->
	</div><!-- .m-author-info -->

</div><!-- .m-author-bio -->