<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Mismo
 */
if ( has_post_thumbnail() ) {
	$post_class = 'has-thumbnail';
} else {
	$post_class = 'no-thumbnail';
}
$thumbnail_url = get_the_post_thumbnail_url();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
	<div class="archive-image">
		<figure class="mismo-bg-img" style="background: no-repeat center top url(<?php echo esc_url( $thumbnail_url ); ?>); background-size: cover; height:280px;">
     	</figure>
	</div><!-- archive-image -->
	<div class="archive-article-content">
		<header class="entry-header">
			<?php
				mismo_post_categories_list();
				the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			?>
		</header><!-- .entry-header -->

		<div class="entry-summary">
			<?php
				the_excerpt();
				mismo_archive_read_more_button();
			?>
		</div><!-- .entry-summary -->

		<footer class="entry-footer">
			<?php mismo_entry_footer(); ?>
		</footer><!-- .entry-footer -->
	</div><!-- archive-article-content -->
	<?php if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php
				mismo_posted_on();
				mismo_posted_by();
			?>
		</div><!-- .entry-meta -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->