<?php
/**
 * Template part for displaying single audio post format content.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Mismo
 */
if ( has_post_thumbnail() ) {
	$post_class 		= 'has-thumbnail';
	$image_url			= get_the_post_thumbnail_url( get_the_ID(), 'full' );
	$post_image_html 	= '<figure><img src ="'. esc_url( $image_url ) .'" /></figure>';
} else {
	$post_class 		= 'no-thumbnail';
	$post_image_html 	= '';
}

$get_content 	= apply_filters( 'the_content', get_the_content() );
$get_audio 		= get_media_embedded_in_content( $get_content, array( 'audio', 'iframe' ) );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
	<div class="single-image">
	<?php 
		if ( !empty( $get_audio ) ) {
	?>
			<div class="post-format-media post-format--audio">
				<?php echo wp_kses_post( $get_audio[0] ); ?>
			</div>
	<?php
		} else {
			echo $post_image_html;
		}
	?>
	</div><!-- single image -->
	<header class="entry-header">
		<?php
			mismo_post_categories_list();
			the_title( '<h1 class="entry-title">', '</h1>' );
		?>
		<div class="entry-meta">
			<?php
				mismo_posted_on();
				mismo_posted_by();
			?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
		the_content( sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'mismo' ),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			),
			get_the_title()
		) );

		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'mismo' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php 
			mismo_post_comment_links();
			mismo_entry_footer();
		?>
	</footer><!-- .entry-footer -->

	<?php
		/**
		 * hook - mismo_before_single_post_article_end
		 * 
		 * @hooked - mismo_author_box_section - 10
		 */
		do_action( 'mismo_before_single_post_article_end' );
	?>
	
</article><!-- #post-<?php the_ID(); ?> -->