<?php
/**
 * Template part for displaying single post content.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Mismo
 */

if ( has_post_thumbnail() ) {
	$post_class 		= 'has-thumbnail';
	$image_url			= get_the_post_thumbnail_url( get_the_ID(), 'full' );
	$post_image_html 	= '<figure><img src ="'. esc_url( $image_url ) .'" /></figure>';
} else {
	$post_class 		= 'no-thumbnail';
	$post_image_html 	= '';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>

	<div class="single-image">
		<?php
			// single post featured image
			echo $post_image_html;
		?>
	</div><!-- single image -->
	
	<header class="entry-header">
		<?php
			mismo_post_categories_list();
			the_title( '<h1 class="entry-title">', '</h1>' );
		?>
		<div class="entry-meta">
			<?php
				mismo_posted_on();
				mismo_posted_by();
			?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
		the_content( sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'mismo' ),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			),
			get_the_title()
		) );

		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'mismo' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php
			mismo_post_comment_links();
			mismo_entry_footer();
		?>
	</footer><!-- .entry-footer -->
	
	<?php
		/**
		 * hook - mismo_before_single_post_article_end
		 * 
		 * @hooked - mismo_author_box_section - 10
		 */
		do_action( 'mismo_before_single_post_article_end' );
	?>

</article><!-- #post-<?php the_ID(); ?> -->