<?php
/**
 * Template part for displaying related posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Mismo
 * 
 * @since 1.0.0
 */

if ( has_post_thumbnail() ) {
    $post_class = 'has-thumbnail wow fadeInUp';
} else {
    $post_class = 'no-thumbnail wow fadeInUp';
}
$thumbnail_url = get_the_post_thumbnail_url();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?> data-wow-delay="0.3s">
    <div class="related-image">
        <figure style="background: no-repeat center top url(<?php echo esc_url( $thumbnail_url ); ?>); background-size: cover; height: 260px;">
        </figure>
    </div><!-- related image -->
	<header class="entry-header">
		<?php
            mismo_post_categories_list();
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		?>
        <div class="entry-meta">
            <?php mismo_posted_on(); ?>
        </div><!-- .entry-meta -->
	</header><!-- .entry-header -->

</article><!-- #post-<?php the_ID(); ?> -->