<?php
/**
 * Related posts template after archive page
 * 
 * @package Mismo
 * 
 * @since 1.0.0
 */

global $post;
$current_post_id = $post->ID;

$you_may_missed_title = get_theme_mod( 'you_may_missed_title', __( 'You May Missed', 'mismo' ) );
$related_posts_args = array(
    'posts_per_page' => 5,
    'post__not_in'   => array( $current_post_id ),
);

$get_categories = get_the_terms( $current_post_id, 'category' );
if ( $get_categories && is_array( $get_categories ) ) {
    $selected_cat = array();
    foreach ( $get_categories as $category ) {
        $selected_cat[] = $category->term_id;
    }
}

$you_may_missed_orderby = get_theme_mod( 'you_may_missed_orderby', 'rp_rand_archive' );
if ( 'rp_rand_archive' === $you_may_missed_orderby ) {
    $related_posts_args['orderby'] = 'rand';
} elseif (  'rp_date_archive' === $you_may_missed_orderby  ) {
    $related_posts_args['orderby'] = 'date';
}

$related_posts_query = new WP_Query( $related_posts_args );

if ( $related_posts_query->have_posts() ) {
?>
    <section class="mismo-archive-related-posts">
        <div class="custom-title">
        <h2 class="mismo-related-post-title widget-title"><?php echo esc_html( $you_may_missed_title ); ?></h2>
        </div><!-- .custom-title -->
        <div class="mismo-related-posts-wrapper mismo-you-may-like-wrapper">
            <?php
                while ( $related_posts_query->have_posts() ) {
                    $related_posts_query->the_post();
                    get_template_part( 'template-parts/related-posts/content', 'related' );
                }
            ?>
        </div><!-- .mismo-related-posts-wrapper -->
    </section><!-- .mismo-archive-related-posts -->
    
<?php
}

wp_reset_postdata();