<?php
/**
 * Template part for displaying posts for featured section.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Mismo
 */
if ( has_post_thumbnail() ) {
    $thumbail_class = 'wow fadeInRight';
} else {
    $thumbail_class = 'no-thumbnail wow fadeInRight';
}
$thumbnail_url = get_the_post_thumbnail_url();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $thumbail_class ); ?>>
    <div class="featured-image">
        <a href="<?php the_permalink(); ?>">
            <figure class="mismo-bg-img" style="background-image: url(<?php echo esc_url( $thumbnail_url ); ?>);  height: 150px;">
            </figure>
        </a>
    </div><!-- featured image -->
    <?php mismo_post_categories_list(); ?>

    <header class="entry-header">
        <?php
            the_title( '<h3 class="post-title small-size"><a href="'.esc_url( get_permalink() ).'" rel="bookmark">', '</a></h3>' );
        ?>
    </header><!-- .entry-header -->
    <div class="entry-meta">
        <?php
            mismo_posted_on();
            mismo_posted_by();
        ?>
    </div><!-- .entry-meta -->
</article><!-- #post-<?php the_ID(); ?> -->