<?php
/**
 * Template part for displaying posts for cariusel widget section.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Mismo
 */
if ( has_post_thumbnail() ) {
    $post_class = 'has-thumbnail';
} else {
    $post_class = 'no-thumbnail';
}
$thumbnail_url = get_the_post_thumbnail_url();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="carousel-image">
        <a href="<?php the_permalink(); ?>">
            <figure class="mismo-bg-img large-image" style="background-image: url(<?php echo esc_url( $thumbnail_url ); ?>);">
            </figure>
        </a>    
    </div><!-- carousel thumbnail -->
    <header class="entry-header">
        <?php
            the_title( '<h3 class="post-title medium-size"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
        ?>
    </header><!-- .entry-header -->
    <div class="entry-meta">
        <?php
            mismo_posted_on();
            mismo_posted_by();
        ?>
    </div><!-- .entry-meta -->
</article><!-- #post-<?php the_ID(); ?> -->