<?php
/**
 * Template Name: Frontpage
 *
 * This is the template that displays all frontpage sections.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Mismo
 */

get_header();

    /**
     * Sidebar content for Banner Section
     */
    if ( is_active_sidebar( 'front-banner-section' ) ) {
        echo '<div class="front-banner-section">';
            dynamic_sidebar( 'front-banner-section' );
        echo '</div><!-- .front-banner-section -->';
    }

    if ( is_active_sidebar( 'front-main-content-section' ) || is_active_sidebar( 'front-main-content-aside' ) ) {
        echo '<div class="front-main-content-wrapper mt-clearfix">';
    }
    /**
     * Sidebar content for Main Content Section
     */
    if ( is_active_sidebar( 'front-main-content-section' ) ) {
        echo '<div id="primary" class="front-main-content">';
            dynamic_sidebar( 'front-main-content-section' );
        echo '</div><!-- #primary -->';
    }

    /**
     * Sidebar content for Main Content Aside
     */
    if ( is_active_sidebar( 'front-main-content-aside' ) ) {
        echo '<div id="secondary" class="front-main-content-aside">';
            dynamic_sidebar( 'front-main-content-aside' );
        echo '</div><!-- #secondary -->';
    }
    if ( is_active_sidebar( 'front-main-content-section' ) || is_active_sidebar( 'front-main-content-aside' ) ) {        
        echo '</div><!-- .front-main-content-wrapper -->';
    }

    /**
     * Sidebar content for Full Width Section
     */
    if ( is_active_sidebar( 'front-full-width-section' ) ) {
        echo '<div class="front-full-width-section">';
            dynamic_sidebar( 'front-full-width-section' );
        echo '</div<<!-- .front-full-width-section -->';
    }

get_footer();