<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package NewSrore
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function newstore_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
	$newstore_body_class = get_theme_mod( 'newstore_site_layout_type', 'full' );
	$classes[] = esc_attr( $newstore_body_class );
	return $classes;
}
add_filter( 'body_class', 'newstore_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function newstore_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'newstore_pingback_header' );
